/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterDocument;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterDocument
implements InputMessagesFilterDocument {
    private final int identifier;
    private static final ImmutableInputMessagesFilterDocument INSTANCE = ImmutableInputMessagesFilterDocument.validate(new ImmutableInputMessagesFilterDocument());

    private ImmutableInputMessagesFilterDocument() {
        this.identifier = InputMessagesFilterDocument.super.identifier();
    }

    private ImmutableInputMessagesFilterDocument(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterDocument.super.identifier();
    }

    private ImmutableInputMessagesFilterDocument(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterDocument withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterDocument.validate(new ImmutableInputMessagesFilterDocument(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterDocument && this.equalTo(0, (ImmutableInputMessagesFilterDocument)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterDocument another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterDocument{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterDocument of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterDocument validate(ImmutableInputMessagesFilterDocument instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterDocument copyOf(InputMessagesFilterDocument instance) {
        if (instance instanceof ImmutableInputMessagesFilterDocument) {
            return (ImmutableInputMessagesFilterDocument)instance;
        }
        return ImmutableInputMessagesFilterDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterDocument) {
                instance = (InputMessagesFilterDocument)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterDocument build() {
            return ImmutableInputMessagesFilterDocument.validate(new ImmutableInputMessagesFilterDocument(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

