/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterEmpty;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterEmpty
implements InputMessagesFilterEmpty {
    private final int identifier;
    private static final ImmutableInputMessagesFilterEmpty INSTANCE = ImmutableInputMessagesFilterEmpty.validate(new ImmutableInputMessagesFilterEmpty());

    private ImmutableInputMessagesFilterEmpty() {
        this.identifier = InputMessagesFilterEmpty.super.identifier();
    }

    private ImmutableInputMessagesFilterEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterEmpty.super.identifier();
    }

    private ImmutableInputMessagesFilterEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterEmpty.validate(new ImmutableInputMessagesFilterEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterEmpty && this.equalTo(0, (ImmutableInputMessagesFilterEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterEmpty validate(ImmutableInputMessagesFilterEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterEmpty copyOf(InputMessagesFilterEmpty instance) {
        if (instance instanceof ImmutableInputMessagesFilterEmpty) {
            return (ImmutableInputMessagesFilterEmpty)instance;
        }
        return ImmutableInputMessagesFilterEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterEmpty) {
                instance = (InputMessagesFilterEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterEmpty build() {
            return ImmutableInputMessagesFilterEmpty.validate(new ImmutableInputMessagesFilterEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

