/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterGeo;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterGeo
implements InputMessagesFilterGeo {
    private final int identifier;
    private static final ImmutableInputMessagesFilterGeo INSTANCE = ImmutableInputMessagesFilterGeo.validate(new ImmutableInputMessagesFilterGeo());

    private ImmutableInputMessagesFilterGeo() {
        this.identifier = InputMessagesFilterGeo.super.identifier();
    }

    private ImmutableInputMessagesFilterGeo(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterGeo.super.identifier();
    }

    private ImmutableInputMessagesFilterGeo(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterGeo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterGeo.validate(new ImmutableInputMessagesFilterGeo(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterGeo && this.equalTo(0, (ImmutableInputMessagesFilterGeo)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterGeo another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterGeo{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterGeo of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterGeo validate(ImmutableInputMessagesFilterGeo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterGeo copyOf(InputMessagesFilterGeo instance) {
        if (instance instanceof ImmutableInputMessagesFilterGeo) {
            return (ImmutableInputMessagesFilterGeo)instance;
        }
        return ImmutableInputMessagesFilterGeo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterGeo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterGeo) {
                instance = (InputMessagesFilterGeo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterGeo build() {
            return ImmutableInputMessagesFilterGeo.validate(new ImmutableInputMessagesFilterGeo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

