/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputMessagesFilterPhoneCalls;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterPhoneCalls
implements InputMessagesFilterPhoneCalls {
    private final int identifier;
    private final int flags;
    private final boolean missed;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableInputMessagesFilterPhoneCalls INSTANCE = ImmutableInputMessagesFilterPhoneCalls.validate(new ImmutableInputMessagesFilterPhoneCalls());

    private ImmutableInputMessagesFilterPhoneCalls() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.missed = this.initShim.missed();
        this.initShim = null;
    }

    private ImmutableInputMessagesFilterPhoneCalls(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.missedIsSet()) {
            this.initShim.missed(builder.missed);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.missed = this.initShim.missed();
        this.initShim = null;
    }

    private ImmutableInputMessagesFilterPhoneCalls(int identifier, int flags, boolean missed) {
        this.identifier = identifier;
        this.flags = flags;
        this.missed = missed;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputMessagesFilterPhoneCalls.super.identifier();
    }

    private int flagsInitialize() {
        return InputMessagesFilterPhoneCalls.super.flags();
    }

    private boolean missedInitialize() {
        return InputMessagesFilterPhoneCalls.super.missed();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean missed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.missed() : this.missed;
    }

    public final ImmutableInputMessagesFilterPhoneCalls withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterPhoneCalls.validate(new ImmutableInputMessagesFilterPhoneCalls(value, this.flags, this.missed));
    }

    public final ImmutableInputMessagesFilterPhoneCalls withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableInputMessagesFilterPhoneCalls.validate(new ImmutableInputMessagesFilterPhoneCalls(this.identifier, value, this.missed));
    }

    public final ImmutableInputMessagesFilterPhoneCalls withMissed(boolean value) {
        if (this.missed == value) {
            return this;
        }
        return ImmutableInputMessagesFilterPhoneCalls.validate(new ImmutableInputMessagesFilterPhoneCalls(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterPhoneCalls && this.equalTo(0, (ImmutableInputMessagesFilterPhoneCalls)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterPhoneCalls another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.missed == another.missed;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.missed);
        return h;
    }

    public String toString() {
        return "InputMessagesFilterPhoneCalls{identifier=" + this.identifier + ", flags=" + this.flags + ", missed=" + this.missed + "}";
    }

    public static ImmutableInputMessagesFilterPhoneCalls of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterPhoneCalls validate(ImmutableInputMessagesFilterPhoneCalls instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterPhoneCalls copyOf(InputMessagesFilterPhoneCalls instance) {
        if (instance instanceof ImmutableInputMessagesFilterPhoneCalls) {
            return (ImmutableInputMessagesFilterPhoneCalls)instance;
        }
        return ImmutableInputMessagesFilterPhoneCalls.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MISSED = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean missed;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterPhoneCalls instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterPhoneCalls) {
                instance = (InputMessagesFilterPhoneCalls)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.missed(instance.missed());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder missed(boolean missed) {
            this.missed = missed;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableInputMessagesFilterPhoneCalls build() {
            return ImmutableInputMessagesFilterPhoneCalls.validate(new ImmutableInputMessagesFilterPhoneCalls(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean missedIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte missedBuildStage = 0;
        private boolean missed;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputMessagesFilterPhoneCalls.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputMessagesFilterPhoneCalls.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean missed() {
            if (this.missedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.missedBuildStage == 0) {
                this.missedBuildStage = (byte)-1;
                this.missed = ImmutableInputMessagesFilterPhoneCalls.this.missedInitialize();
                this.missedBuildStage = 1;
            }
            return this.missed;
        }

        void missed(boolean missed) {
            this.missed = missed;
            this.missedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.missedBuildStage == -1) {
                attributes.add("missed");
            }
            return "Cannot build InputMessagesFilterPhoneCalls, attribute initializers form cycle " + attributes;
        }
    }
}

