/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterPinned;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterPinned
implements InputMessagesFilterPinned {
    private final int identifier;
    private static final ImmutableInputMessagesFilterPinned INSTANCE = ImmutableInputMessagesFilterPinned.validate(new ImmutableInputMessagesFilterPinned());

    private ImmutableInputMessagesFilterPinned() {
        this.identifier = InputMessagesFilterPinned.super.identifier();
    }

    private ImmutableInputMessagesFilterPinned(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterPinned.super.identifier();
    }

    private ImmutableInputMessagesFilterPinned(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterPinned withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterPinned.validate(new ImmutableInputMessagesFilterPinned(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterPinned && this.equalTo(0, (ImmutableInputMessagesFilterPinned)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterPinned another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterPinned{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterPinned of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterPinned validate(ImmutableInputMessagesFilterPinned instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterPinned copyOf(InputMessagesFilterPinned instance) {
        if (instance instanceof ImmutableInputMessagesFilterPinned) {
            return (ImmutableInputMessagesFilterPinned)instance;
        }
        return ImmutableInputMessagesFilterPinned.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputMessagesFilterPinned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof InputMessagesFilterPinned) {
                instance = (InputMessagesFilterPinned)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterPinned build() {
            return ImmutableInputMessagesFilterPinned.validate(new ImmutableInputMessagesFilterPinned(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

