/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterRoundVideo;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterRoundVideo
implements InputMessagesFilterRoundVideo {
    private final int identifier;
    private static final ImmutableInputMessagesFilterRoundVideo INSTANCE = ImmutableInputMessagesFilterRoundVideo.validate(new ImmutableInputMessagesFilterRoundVideo());

    private ImmutableInputMessagesFilterRoundVideo() {
        this.identifier = InputMessagesFilterRoundVideo.super.identifier();
    }

    private ImmutableInputMessagesFilterRoundVideo(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterRoundVideo.super.identifier();
    }

    private ImmutableInputMessagesFilterRoundVideo(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterRoundVideo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterRoundVideo.validate(new ImmutableInputMessagesFilterRoundVideo(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterRoundVideo && this.equalTo(0, (ImmutableInputMessagesFilterRoundVideo)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterRoundVideo another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterRoundVideo{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterRoundVideo of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterRoundVideo validate(ImmutableInputMessagesFilterRoundVideo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterRoundVideo copyOf(InputMessagesFilterRoundVideo instance) {
        if (instance instanceof ImmutableInputMessagesFilterRoundVideo) {
            return (ImmutableInputMessagesFilterRoundVideo)instance;
        }
        return ImmutableInputMessagesFilterRoundVideo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterRoundVideo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterRoundVideo) {
                instance = (InputMessagesFilterRoundVideo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterRoundVideo build() {
            return ImmutableInputMessagesFilterRoundVideo.validate(new ImmutableInputMessagesFilterRoundVideo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

