/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterUrl;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterUrl
implements InputMessagesFilterUrl {
    private final int identifier;
    private static final ImmutableInputMessagesFilterUrl INSTANCE = ImmutableInputMessagesFilterUrl.validate(new ImmutableInputMessagesFilterUrl());

    private ImmutableInputMessagesFilterUrl() {
        this.identifier = InputMessagesFilterUrl.super.identifier();
    }

    private ImmutableInputMessagesFilterUrl(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterUrl.super.identifier();
    }

    private ImmutableInputMessagesFilterUrl(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterUrl withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterUrl.validate(new ImmutableInputMessagesFilterUrl(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterUrl && this.equalTo(0, (ImmutableInputMessagesFilterUrl)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterUrl another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterUrl{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterUrl of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterUrl validate(ImmutableInputMessagesFilterUrl instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterUrl copyOf(InputMessagesFilterUrl instance) {
        if (instance instanceof ImmutableInputMessagesFilterUrl) {
            return (ImmutableInputMessagesFilterUrl)instance;
        }
        return ImmutableInputMessagesFilterUrl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterUrl) {
                instance = (InputMessagesFilterUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterUrl build() {
            return ImmutableInputMessagesFilterUrl.validate(new ImmutableInputMessagesFilterUrl(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

