/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterVideo;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterVideo
implements InputMessagesFilterVideo {
    private final int identifier;
    private static final ImmutableInputMessagesFilterVideo INSTANCE = ImmutableInputMessagesFilterVideo.validate(new ImmutableInputMessagesFilterVideo());

    private ImmutableInputMessagesFilterVideo() {
        this.identifier = InputMessagesFilterVideo.super.identifier();
    }

    private ImmutableInputMessagesFilterVideo(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterVideo.super.identifier();
    }

    private ImmutableInputMessagesFilterVideo(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterVideo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterVideo.validate(new ImmutableInputMessagesFilterVideo(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterVideo && this.equalTo(0, (ImmutableInputMessagesFilterVideo)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterVideo another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterVideo{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterVideo of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterVideo validate(ImmutableInputMessagesFilterVideo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterVideo copyOf(InputMessagesFilterVideo instance) {
        if (instance instanceof ImmutableInputMessagesFilterVideo) {
            return (ImmutableInputMessagesFilterVideo)instance;
        }
        return ImmutableInputMessagesFilterVideo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterVideo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterVideo) {
                instance = (InputMessagesFilterVideo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterVideo build() {
            return ImmutableInputMessagesFilterVideo.validate(new ImmutableInputMessagesFilterVideo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

