/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputMessagesFilterVoice;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputMessagesFilterVoice
implements InputMessagesFilterVoice {
    private final int identifier;
    private static final ImmutableInputMessagesFilterVoice INSTANCE = ImmutableInputMessagesFilterVoice.validate(new ImmutableInputMessagesFilterVoice());

    private ImmutableInputMessagesFilterVoice() {
        this.identifier = InputMessagesFilterVoice.super.identifier();
    }

    private ImmutableInputMessagesFilterVoice(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputMessagesFilterVoice.super.identifier();
    }

    private ImmutableInputMessagesFilterVoice(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputMessagesFilterVoice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputMessagesFilterVoice.validate(new ImmutableInputMessagesFilterVoice(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMessagesFilterVoice && this.equalTo(0, (ImmutableInputMessagesFilterVoice)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputMessagesFilterVoice another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputMessagesFilterVoice{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputMessagesFilterVoice of() {
        return INSTANCE;
    }

    private static ImmutableInputMessagesFilterVoice validate(ImmutableInputMessagesFilterVoice instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputMessagesFilterVoice copyOf(InputMessagesFilterVoice instance) {
        if (instance instanceof ImmutableInputMessagesFilterVoice) {
            return (ImmutableInputMessagesFilterVoice)instance;
        }
        return ImmutableInputMessagesFilterVoice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessagesFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputMessagesFilterVoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagesFilter instance;
            long bits = 0L;
            if (object instanceof MessagesFilter) {
                instance = (MessagesFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputMessagesFilterVoice) {
                instance = (InputMessagesFilterVoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputMessagesFilterVoice build() {
            return ImmutableInputMessagesFilterVoice.validate(new ImmutableInputMessagesFilterVoice(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

