/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputNotifyBroadcasts;
import telegram4j.tl.InputNotifyPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputNotifyBroadcasts
implements InputNotifyBroadcasts {
    private final int identifier;
    private static final ImmutableInputNotifyBroadcasts INSTANCE = ImmutableInputNotifyBroadcasts.validate(new ImmutableInputNotifyBroadcasts());

    private ImmutableInputNotifyBroadcasts() {
        this.identifier = InputNotifyBroadcasts.super.identifier();
    }

    private ImmutableInputNotifyBroadcasts(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputNotifyBroadcasts.super.identifier();
    }

    private ImmutableInputNotifyBroadcasts(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputNotifyBroadcasts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputNotifyBroadcasts.validate(new ImmutableInputNotifyBroadcasts(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputNotifyBroadcasts && this.equalTo(0, (ImmutableInputNotifyBroadcasts)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputNotifyBroadcasts another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputNotifyBroadcasts{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputNotifyBroadcasts of() {
        return INSTANCE;
    }

    private static ImmutableInputNotifyBroadcasts validate(ImmutableInputNotifyBroadcasts instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputNotifyBroadcasts copyOf(InputNotifyBroadcasts instance) {
        if (instance instanceof ImmutableInputNotifyBroadcasts) {
            return (ImmutableInputNotifyBroadcasts)instance;
        }
        return ImmutableInputNotifyBroadcasts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputNotifyPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputNotifyBroadcasts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputNotifyPeer instance;
            long bits = 0L;
            if (object instanceof InputNotifyPeer) {
                instance = (InputNotifyPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputNotifyBroadcasts) {
                instance = (InputNotifyBroadcasts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputNotifyBroadcasts build() {
            return ImmutableInputNotifyBroadcasts.validate(new ImmutableInputNotifyBroadcasts(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

