/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputNotifyChats;
import telegram4j.tl.InputNotifyPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputNotifyChats
implements InputNotifyChats {
    private final int identifier;
    private static final ImmutableInputNotifyChats INSTANCE = ImmutableInputNotifyChats.validate(new ImmutableInputNotifyChats());

    private ImmutableInputNotifyChats() {
        this.identifier = InputNotifyChats.super.identifier();
    }

    private ImmutableInputNotifyChats(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputNotifyChats.super.identifier();
    }

    private ImmutableInputNotifyChats(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputNotifyChats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputNotifyChats.validate(new ImmutableInputNotifyChats(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputNotifyChats && this.equalTo(0, (ImmutableInputNotifyChats)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputNotifyChats another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputNotifyChats{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputNotifyChats of() {
        return INSTANCE;
    }

    private static ImmutableInputNotifyChats validate(ImmutableInputNotifyChats instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputNotifyChats copyOf(InputNotifyChats instance) {
        if (instance instanceof ImmutableInputNotifyChats) {
            return (ImmutableInputNotifyChats)instance;
        }
        return ImmutableInputNotifyChats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputNotifyPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputNotifyChats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputNotifyPeer instance;
            long bits = 0L;
            if (object instanceof InputNotifyPeer) {
                instance = (InputNotifyPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputNotifyChats) {
                instance = (InputNotifyChats)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputNotifyChats build() {
            return ImmutableInputNotifyChats.validate(new ImmutableInputNotifyChats(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

