/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputNotifyPeer;
import telegram4j.tl.InputNotifyUsers;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputNotifyUsers
implements InputNotifyUsers {
    private final int identifier;
    private static final ImmutableInputNotifyUsers INSTANCE = ImmutableInputNotifyUsers.validate(new ImmutableInputNotifyUsers());

    private ImmutableInputNotifyUsers() {
        this.identifier = InputNotifyUsers.super.identifier();
    }

    private ImmutableInputNotifyUsers(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputNotifyUsers.super.identifier();
    }

    private ImmutableInputNotifyUsers(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputNotifyUsers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputNotifyUsers.validate(new ImmutableInputNotifyUsers(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputNotifyUsers && this.equalTo(0, (ImmutableInputNotifyUsers)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputNotifyUsers another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputNotifyUsers{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputNotifyUsers of() {
        return INSTANCE;
    }

    private static ImmutableInputNotifyUsers validate(ImmutableInputNotifyUsers instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputNotifyUsers copyOf(InputNotifyUsers instance) {
        if (instance instanceof ImmutableInputNotifyUsers) {
            return (ImmutableInputNotifyUsers)instance;
        }
        return ImmutableInputNotifyUsers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputNotifyPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputNotifyUsers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputNotifyPeer instance;
            long bits = 0L;
            if (object instanceof InputNotifyPeer) {
                instance = (InputNotifyPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputNotifyUsers) {
                instance = (InputNotifyUsers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputNotifyUsers build() {
            return ImmutableInputNotifyUsers.validate(new ImmutableInputNotifyUsers(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

