/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputPaymentCredentials;
import telegram4j.tl.InputPaymentCredentialsApplePay;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPaymentCredentialsApplePay
implements InputPaymentCredentialsApplePay {
    private final int identifier;
    private final DataJSON paymentData;

    private ImmutableInputPaymentCredentialsApplePay(DataJSON paymentData) {
        this.paymentData = Objects.requireNonNull(paymentData, "paymentData");
        this.identifier = InputPaymentCredentialsApplePay.super.identifier();
    }

    private ImmutableInputPaymentCredentialsApplePay(Builder builder) {
        this.paymentData = builder.paymentData;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPaymentCredentialsApplePay.super.identifier();
    }

    private ImmutableInputPaymentCredentialsApplePay(int identifier, DataJSON paymentData) {
        this.identifier = identifier;
        this.paymentData = paymentData;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public DataJSON paymentData() {
        return this.paymentData;
    }

    public final ImmutableInputPaymentCredentialsApplePay withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPaymentCredentialsApplePay(value, this.paymentData);
    }

    public final ImmutableInputPaymentCredentialsApplePay withPaymentData(DataJSON value) {
        if (this.paymentData == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "paymentData");
        return new ImmutableInputPaymentCredentialsApplePay(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPaymentCredentialsApplePay && this.equalTo(0, (ImmutableInputPaymentCredentialsApplePay)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPaymentCredentialsApplePay another) {
        return this.identifier == another.identifier && this.paymentData.equals(another.paymentData);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.paymentData.hashCode();
        return h;
    }

    public String toString() {
        return "InputPaymentCredentialsApplePay{identifier=" + this.identifier + ", paymentData=" + this.paymentData + "}";
    }

    public static ImmutableInputPaymentCredentialsApplePay of(DataJSON paymentData) {
        return new ImmutableInputPaymentCredentialsApplePay(paymentData);
    }

    public static ImmutableInputPaymentCredentialsApplePay copyOf(InputPaymentCredentialsApplePay instance) {
        if (instance instanceof ImmutableInputPaymentCredentialsApplePay) {
            return (ImmutableInputPaymentCredentialsApplePay)instance;
        }
        return ImmutableInputPaymentCredentialsApplePay.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PAYMENT_DATA = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private DataJSON paymentData;

        private Builder() {
        }

        public final Builder from(InputPaymentCredentialsApplePay instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPaymentCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPaymentCredentials instance;
            long bits = 0L;
            if (object instanceof InputPaymentCredentialsApplePay) {
                instance = (InputPaymentCredentialsApplePay)object;
                this.paymentData(instance.paymentData());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPaymentCredentials) {
                instance = (InputPaymentCredentials)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder paymentData(DataJSON paymentData) {
            this.paymentData = Objects.requireNonNull(paymentData, "paymentData");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputPaymentCredentialsApplePay build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPaymentCredentialsApplePay(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("paymentData");
            }
            return "Cannot build InputPaymentCredentialsApplePay, some of required attributes are not set " + attributes;
        }
    }
}

