/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputPaymentCredentials;
import telegram4j.tl.InputPaymentCredentialsGooglePay;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPaymentCredentialsGooglePay
implements InputPaymentCredentialsGooglePay {
    private final int identifier;
    private final DataJSON paymentToken;

    private ImmutableInputPaymentCredentialsGooglePay(DataJSON paymentToken) {
        this.paymentToken = Objects.requireNonNull(paymentToken, "paymentToken");
        this.identifier = InputPaymentCredentialsGooglePay.super.identifier();
    }

    private ImmutableInputPaymentCredentialsGooglePay(Builder builder) {
        this.paymentToken = builder.paymentToken;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPaymentCredentialsGooglePay.super.identifier();
    }

    private ImmutableInputPaymentCredentialsGooglePay(int identifier, DataJSON paymentToken) {
        this.identifier = identifier;
        this.paymentToken = paymentToken;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public DataJSON paymentToken() {
        return this.paymentToken;
    }

    public final ImmutableInputPaymentCredentialsGooglePay withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPaymentCredentialsGooglePay(value, this.paymentToken);
    }

    public final ImmutableInputPaymentCredentialsGooglePay withPaymentToken(DataJSON value) {
        if (this.paymentToken == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "paymentToken");
        return new ImmutableInputPaymentCredentialsGooglePay(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPaymentCredentialsGooglePay && this.equalTo(0, (ImmutableInputPaymentCredentialsGooglePay)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPaymentCredentialsGooglePay another) {
        return this.identifier == another.identifier && this.paymentToken.equals(another.paymentToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.paymentToken.hashCode();
        return h;
    }

    public String toString() {
        return "InputPaymentCredentialsGooglePay{identifier=" + this.identifier + ", paymentToken=" + this.paymentToken + "}";
    }

    public static ImmutableInputPaymentCredentialsGooglePay of(DataJSON paymentToken) {
        return new ImmutableInputPaymentCredentialsGooglePay(paymentToken);
    }

    public static ImmutableInputPaymentCredentialsGooglePay copyOf(InputPaymentCredentialsGooglePay instance) {
        if (instance instanceof ImmutableInputPaymentCredentialsGooglePay) {
            return (ImmutableInputPaymentCredentialsGooglePay)instance;
        }
        return ImmutableInputPaymentCredentialsGooglePay.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PAYMENT_TOKEN = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private DataJSON paymentToken;

        private Builder() {
        }

        public final Builder from(InputPaymentCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPaymentCredentialsGooglePay instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPaymentCredentials instance;
            long bits = 0L;
            if (object instanceof InputPaymentCredentials) {
                instance = (InputPaymentCredentials)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPaymentCredentialsGooglePay) {
                instance = (InputPaymentCredentialsGooglePay)object;
                this.paymentToken(instance.paymentToken());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder paymentToken(DataJSON paymentToken) {
            this.paymentToken = Objects.requireNonNull(paymentToken, "paymentToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputPaymentCredentialsGooglePay build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPaymentCredentialsGooglePay(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("paymentToken");
            }
            return "Cannot build InputPaymentCredentialsGooglePay, some of required attributes are not set " + attributes;
        }
    }
}

