/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPaymentCredentials;
import telegram4j.tl.InputPaymentCredentialsSaved;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPaymentCredentialsSaved
implements InputPaymentCredentialsSaved {
    private final int identifier;
    private final String id;
    private final ByteBuf tmpPassword;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputPaymentCredentialsSaved(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.tmpPassword = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputPaymentCredentialsSaved(Builder builder) {
        this.id = builder.id;
        this.tmpPassword = builder.tmpPassword_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputPaymentCredentialsSaved(int identifier, String id, ByteBuf tmpPassword) {
        this.identifier = identifier;
        this.id = id;
        this.tmpPassword = tmpPassword;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputPaymentCredentialsSaved.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ByteBuf tmpPassword() {
        return this.tmpPassword.duplicate();
    }

    public final ImmutableInputPaymentCredentialsSaved withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPaymentCredentialsSaved(value, this.id, this.tmpPassword);
    }

    public final ImmutableInputPaymentCredentialsSaved withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableInputPaymentCredentialsSaved(this.identifier, newValue, this.tmpPassword);
    }

    public ImmutableInputPaymentCredentialsSaved withTmpPassword(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.tmpPassword == newValue) {
            return this;
        }
        return new ImmutableInputPaymentCredentialsSaved(this.identifier, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPaymentCredentialsSaved && this.equalTo(0, (ImmutableInputPaymentCredentialsSaved)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPaymentCredentialsSaved another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.tmpPassword().equals((Object)another.tmpPassword());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.tmpPassword().hashCode();
        return h;
    }

    public String toString() {
        return "InputPaymentCredentialsSaved{identifier=" + this.identifier + ", id=" + this.id + ", tmpPassword=" + ByteBufUtil.hexDump((ByteBuf)this.tmpPassword) + "}";
    }

    public static ImmutableInputPaymentCredentialsSaved of(String id) {
        return new ImmutableInputPaymentCredentialsSaved(id);
    }

    public static ImmutableInputPaymentCredentialsSaved copyOf(InputPaymentCredentialsSaved instance) {
        if (instance instanceof ImmutableInputPaymentCredentialsSaved) {
            return (ImmutableInputPaymentCredentialsSaved)instance;
        }
        return ImmutableInputPaymentCredentialsSaved.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf tmpPassword_value = null;
        private int identifier;
        private String id;

        private Builder() {
        }

        public final Builder from(InputPaymentCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPaymentCredentialsSaved instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPaymentCredentials instance;
            long bits = 0L;
            if (object instanceof InputPaymentCredentials) {
                instance = (InputPaymentCredentials)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPaymentCredentialsSaved) {
                instance = (InputPaymentCredentialsSaved)object;
                this.tmpPassword(instance.tmpPassword());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder tmpPassword(ByteBuf value) {
            this.tmpPassword_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableInputPaymentCredentialsSaved build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPaymentCredentialsSaved(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build InputPaymentCredentialsSaved, some of required attributes are not set " + attributes;
        }

        private ByteBuf tmpPassword_build() {
            return Objects.requireNonNull(this.tmpPassword_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputPaymentCredentialsSaved.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build InputPaymentCredentialsSaved, attribute initializers form cycle " + attributes;
        }
    }
}

