/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputPeerEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPeerEmpty
implements InputPeerEmpty {
    private final int identifier;
    private static final ImmutableInputPeerEmpty INSTANCE = ImmutableInputPeerEmpty.validate(new ImmutableInputPeerEmpty());

    private ImmutableInputPeerEmpty() {
        this.identifier = InputPeerEmpty.super.identifier();
    }

    private ImmutableInputPeerEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPeerEmpty.super.identifier();
    }

    private ImmutableInputPeerEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputPeerEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputPeerEmpty.validate(new ImmutableInputPeerEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPeerEmpty && this.equalTo(0, (ImmutableInputPeerEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPeerEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputPeerEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputPeerEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputPeerEmpty validate(ImmutableInputPeerEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputPeerEmpty copyOf(InputPeerEmpty instance) {
        if (instance instanceof ImmutableInputPeerEmpty) {
            return (ImmutableInputPeerEmpty)instance;
        }
        return ImmutableInputPeerEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeerEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPeer) {
                instance = (InputPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPeerEmpty) {
                instance = (InputPeerEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputPeerEmpty build() {
            return ImmutableInputPeerEmpty.validate(new ImmutableInputPeerEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

