/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputPeerNotifySettings;
import telegram4j.tl.NotificationSound;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPeerNotifySettings
implements InputPeerNotifySettings {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Boolean showPreviews;
    @Nullable
    private final Boolean silent;
    @Nullable
    private final Integer muteUntil;
    @Nullable
    private final NotificationSound sound;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableInputPeerNotifySettings INSTANCE = ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings());

    private ImmutableInputPeerNotifySettings() {
        this.showPreviews = null;
        this.silent = null;
        this.muteUntil = null;
        this.sound = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputPeerNotifySettings(Builder builder) {
        this.showPreviews = builder.showPreviews;
        this.silent = builder.silent;
        this.muteUntil = builder.muteUntil;
        this.sound = builder.sound;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputPeerNotifySettings(int identifier, int flags, @Nullable Boolean showPreviews, @Nullable Boolean silent, @Nullable Integer muteUntil, @Nullable NotificationSound sound) {
        this.identifier = identifier;
        this.flags = flags;
        this.showPreviews = showPreviews;
        this.silent = silent;
        this.muteUntil = muteUntil;
        this.sound = sound;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputPeerNotifySettings.super.identifier();
    }

    private int flagsInitialize() {
        return InputPeerNotifySettings.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Boolean showPreviews() {
        return this.showPreviews;
    }

    @Override
    @Nullable
    public Boolean silent() {
        return this.silent;
    }

    @Override
    @Nullable
    public Integer muteUntil() {
        return this.muteUntil;
    }

    @Override
    @Nullable
    public NotificationSound sound() {
        return this.sound;
    }

    public final ImmutableInputPeerNotifySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings(value, this.flags, this.showPreviews, this.silent, this.muteUntil, this.sound));
    }

    public final ImmutableInputPeerNotifySettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings(this.identifier, value, this.showPreviews, this.silent, this.muteUntil, this.sound));
    }

    public final ImmutableInputPeerNotifySettings withShowPreviews(@Nullable Boolean value) {
        if (Objects.equals(this.showPreviews, value)) {
            return this;
        }
        return ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings(this.identifier, this.flags, value, this.silent, this.muteUntil, this.sound));
    }

    public final ImmutableInputPeerNotifySettings withSilent(@Nullable Boolean value) {
        if (Objects.equals(this.silent, value)) {
            return this;
        }
        return ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings(this.identifier, this.flags, this.showPreviews, value, this.muteUntil, this.sound));
    }

    public final ImmutableInputPeerNotifySettings withMuteUntil(@Nullable Integer value) {
        if (Objects.equals(this.muteUntil, value)) {
            return this;
        }
        return ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings(this.identifier, this.flags, this.showPreviews, this.silent, value, this.sound));
    }

    public final ImmutableInputPeerNotifySettings withSound(@Nullable NotificationSound value) {
        if (this.sound == value) {
            return this;
        }
        return ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings(this.identifier, this.flags, this.showPreviews, this.silent, this.muteUntil, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPeerNotifySettings && this.equalTo(0, (ImmutableInputPeerNotifySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPeerNotifySettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.showPreviews, another.showPreviews) && Objects.equals(this.silent, another.silent) && Objects.equals(this.muteUntil, another.muteUntil) && Objects.equals(this.sound, another.sound);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.showPreviews);
        h += (h << 5) + Objects.hashCode(this.silent);
        h += (h << 5) + Objects.hashCode(this.muteUntil);
        h += (h << 5) + Objects.hashCode(this.sound);
        return h;
    }

    public String toString() {
        return "InputPeerNotifySettings{identifier=" + this.identifier + ", flags=" + this.flags + ", showPreviews=" + this.showPreviews + ", silent=" + this.silent + ", muteUntil=" + this.muteUntil + ", sound=" + this.sound + "}";
    }

    public static ImmutableInputPeerNotifySettings of() {
        return INSTANCE;
    }

    private static ImmutableInputPeerNotifySettings validate(ImmutableInputPeerNotifySettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputPeerNotifySettings copyOf(InputPeerNotifySettings instance) {
        if (instance instanceof ImmutableInputPeerNotifySettings) {
            return (ImmutableInputPeerNotifySettings)instance;
        }
        return ImmutableInputPeerNotifySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Boolean showPreviews;
        private Boolean silent;
        private Integer muteUntil;
        private NotificationSound sound;

        private Builder() {
        }

        public final Builder from(InputPeerNotifySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPeerNotifySettings instance;
            long bits = 0L;
            if (object instanceof InputPeerNotifySettings) {
                Integer muteUntilValue;
                NotificationSound soundValue;
                Boolean showPreviewsValue;
                Boolean silentValue;
                instance = (InputPeerNotifySettings)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((silentValue = instance.silent()) != null) {
                    this.silent(silentValue);
                }
                if ((showPreviewsValue = instance.showPreviews()) != null) {
                    this.showPreviews(showPreviewsValue);
                }
                if ((soundValue = instance.sound()) != null) {
                    this.sound(soundValue);
                }
                if ((muteUntilValue = instance.muteUntil()) != null) {
                    this.muteUntil(muteUntilValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder showPreviews(@Nullable Boolean showPreviews) {
            this.showPreviews = showPreviews;
            return this;
        }

        public final Builder silent(@Nullable Boolean silent) {
            this.silent = silent;
            return this;
        }

        public final Builder muteUntil(@Nullable Integer muteUntil) {
            this.muteUntil = muteUntil;
            return this;
        }

        public final Builder sound(@Nullable NotificationSound sound) {
            this.sound = sound;
            return this;
        }

        public ImmutableInputPeerNotifySettings build() {
            return ImmutableInputPeerNotifySettings.validate(new ImmutableInputPeerNotifySettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputPeerNotifySettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputPeerNotifySettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputPeerNotifySettings, attribute initializers form cycle " + attributes;
        }
    }
}

