/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputPeerPhotoFileLocation;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPeerPhotoFileLocation
implements InputPeerPhotoFileLocation {
    private final int identifier;
    private final int flags;
    private final boolean big;
    private final InputPeer peer;
    private final long photoId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputPeerPhotoFileLocation(InputPeer peer, long photoId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.photoId = photoId;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.initShim = null;
    }

    private ImmutableInputPeerPhotoFileLocation(Builder builder) {
        this.peer = builder.peer;
        this.photoId = builder.photoId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.bigIsSet()) {
            this.initShim.big(builder.big);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.initShim = null;
    }

    private ImmutableInputPeerPhotoFileLocation(int identifier, int flags, boolean big, InputPeer peer, long photoId) {
        this.identifier = identifier;
        this.flags = flags;
        this.big = big;
        this.peer = peer;
        this.photoId = photoId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputPeerPhotoFileLocation.super.identifier();
    }

    private int flagsInitialize() {
        return InputPeerPhotoFileLocation.super.flags();
    }

    private boolean bigInitialize() {
        return InputPeerPhotoFileLocation.super.big();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean big() {
        InitShim shim = this.initShim;
        return shim != null ? shim.big() : this.big;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public long photoId() {
        return this.photoId;
    }

    public final ImmutableInputPeerPhotoFileLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocation(value, this.flags, this.big, this.peer, this.photoId);
    }

    public final ImmutableInputPeerPhotoFileLocation withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocation(this.identifier, value, this.big, this.peer, this.photoId);
    }

    public final ImmutableInputPeerPhotoFileLocation withBig(boolean value) {
        if (this.big == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocation(this.identifier, this.flags, value, this.peer, this.photoId);
    }

    public final ImmutableInputPeerPhotoFileLocation withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableInputPeerPhotoFileLocation(this.identifier, this.flags, this.big, newValue, this.photoId);
    }

    public final ImmutableInputPeerPhotoFileLocation withPhotoId(long value) {
        if (this.photoId == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocation(this.identifier, this.flags, this.big, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPeerPhotoFileLocation && this.equalTo(0, (ImmutableInputPeerPhotoFileLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPeerPhotoFileLocation another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.big == another.big && this.peer.equals(another.peer) && this.photoId == another.photoId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.big);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.photoId);
        return h;
    }

    public String toString() {
        return "InputPeerPhotoFileLocation{identifier=" + this.identifier + ", flags=" + this.flags + ", big=" + this.big + ", peer=" + this.peer + ", photoId=" + this.photoId + "}";
    }

    public static ImmutableInputPeerPhotoFileLocation of(InputPeer peer, long photoId) {
        return new ImmutableInputPeerPhotoFileLocation(peer, photoId);
    }

    public static ImmutableInputPeerPhotoFileLocation copyOf(InputPeerPhotoFileLocation instance) {
        if (instance instanceof ImmutableInputPeerPhotoFileLocation) {
            return (ImmutableInputPeerPhotoFileLocation)instance;
        }
        return ImmutableInputPeerPhotoFileLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_PHOTO_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BIG = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean big;
        private InputPeer peer;
        private long photoId;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeerPhotoFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPeerPhotoFileLocation) {
                instance = (InputPeerPhotoFileLocation)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.big(instance.big());
                this.photoId(instance.photoId());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder big(boolean big) {
            this.big = big;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder photoId(long photoId) {
            this.photoId = photoId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputPeerPhotoFileLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPeerPhotoFileLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean bigIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("photoId");
            }
            return "Cannot build InputPeerPhotoFileLocation, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte bigBuildStage = 0;
        private boolean big;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputPeerPhotoFileLocation.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputPeerPhotoFileLocation.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean big() {
            if (this.bigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bigBuildStage == 0) {
                this.bigBuildStage = (byte)-1;
                this.big = ImmutableInputPeerPhotoFileLocation.this.bigInitialize();
                this.bigBuildStage = 1;
            }
            return this.big;
        }

        void big(boolean big) {
            this.big = big;
            this.bigBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.bigBuildStage == -1) {
                attributes.add("big");
            }
            return "Cannot build InputPeerPhotoFileLocation, attribute initializers form cycle " + attributes;
        }
    }
}

