/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputPeerPhotoFileLocationLegacy;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPeerPhotoFileLocationLegacy
implements InputPeerPhotoFileLocationLegacy {
    private final int identifier;
    private final int flags;
    private final boolean big;
    private final InputPeer peer;
    private final long volumeId;
    private final int localId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputPeerPhotoFileLocationLegacy(InputPeer peer, long volumeId, int localId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.volumeId = volumeId;
        this.localId = localId;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.initShim = null;
    }

    private ImmutableInputPeerPhotoFileLocationLegacy(Builder builder) {
        this.peer = builder.peer;
        this.volumeId = builder.volumeId;
        this.localId = builder.localId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.bigIsSet()) {
            this.initShim.big(builder.big);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.initShim = null;
    }

    private ImmutableInputPeerPhotoFileLocationLegacy(int identifier, int flags, boolean big, InputPeer peer, long volumeId, int localId) {
        this.identifier = identifier;
        this.flags = flags;
        this.big = big;
        this.peer = peer;
        this.volumeId = volumeId;
        this.localId = localId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputPeerPhotoFileLocationLegacy.super.identifier();
    }

    private int flagsInitialize() {
        return InputPeerPhotoFileLocationLegacy.super.flags();
    }

    private boolean bigInitialize() {
        return InputPeerPhotoFileLocationLegacy.super.big();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean big() {
        InitShim shim = this.initShim;
        return shim != null ? shim.big() : this.big;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public long volumeId() {
        return this.volumeId;
    }

    @Override
    public int localId() {
        return this.localId;
    }

    public final ImmutableInputPeerPhotoFileLocationLegacy withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocationLegacy(value, this.flags, this.big, this.peer, this.volumeId, this.localId);
    }

    public final ImmutableInputPeerPhotoFileLocationLegacy withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocationLegacy(this.identifier, value, this.big, this.peer, this.volumeId, this.localId);
    }

    public final ImmutableInputPeerPhotoFileLocationLegacy withBig(boolean value) {
        if (this.big == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocationLegacy(this.identifier, this.flags, value, this.peer, this.volumeId, this.localId);
    }

    public final ImmutableInputPeerPhotoFileLocationLegacy withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableInputPeerPhotoFileLocationLegacy(this.identifier, this.flags, this.big, newValue, this.volumeId, this.localId);
    }

    public final ImmutableInputPeerPhotoFileLocationLegacy withVolumeId(long value) {
        if (this.volumeId == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocationLegacy(this.identifier, this.flags, this.big, this.peer, value, this.localId);
    }

    public final ImmutableInputPeerPhotoFileLocationLegacy withLocalId(int value) {
        if (this.localId == value) {
            return this;
        }
        return new ImmutableInputPeerPhotoFileLocationLegacy(this.identifier, this.flags, this.big, this.peer, this.volumeId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPeerPhotoFileLocationLegacy && this.equalTo(0, (ImmutableInputPeerPhotoFileLocationLegacy)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPeerPhotoFileLocationLegacy another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.big == another.big && this.peer.equals(another.peer) && this.volumeId == another.volumeId && this.localId == another.localId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.big);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.volumeId);
        h += (h << 5) + this.localId;
        return h;
    }

    public String toString() {
        return "InputPeerPhotoFileLocationLegacy{identifier=" + this.identifier + ", flags=" + this.flags + ", big=" + this.big + ", peer=" + this.peer + ", volumeId=" + this.volumeId + ", localId=" + this.localId + "}";
    }

    public static ImmutableInputPeerPhotoFileLocationLegacy of(InputPeer peer, long volumeId, int localId) {
        return new ImmutableInputPeerPhotoFileLocationLegacy(peer, volumeId, localId);
    }

    public static ImmutableInputPeerPhotoFileLocationLegacy copyOf(InputPeerPhotoFileLocationLegacy instance) {
        if (instance instanceof ImmutableInputPeerPhotoFileLocationLegacy) {
            return (ImmutableInputPeerPhotoFileLocationLegacy)instance;
        }
        return ImmutableInputPeerPhotoFileLocationLegacy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_VOLUME_ID = 2L;
        private static final long INIT_BIT_LOCAL_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BIG = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean big;
        private InputPeer peer;
        private long volumeId;
        private int localId;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeerPhotoFileLocationLegacy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPeerPhotoFileLocationLegacy) {
                instance = (InputPeerPhotoFileLocationLegacy)object;
                this.flags(instance.flags());
                this.volumeId(instance.volumeId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.big(instance.big());
                this.localId(instance.localId());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder big(boolean big) {
            this.big = big;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder volumeId(long volumeId) {
            this.volumeId = volumeId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder localId(int localId) {
            this.localId = localId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputPeerPhotoFileLocationLegacy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPeerPhotoFileLocationLegacy(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean bigIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("volumeId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("localId");
            }
            return "Cannot build InputPeerPhotoFileLocationLegacy, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte bigBuildStage = 0;
        private boolean big;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputPeerPhotoFileLocationLegacy.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputPeerPhotoFileLocationLegacy.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean big() {
            if (this.bigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bigBuildStage == 0) {
                this.bigBuildStage = (byte)-1;
                this.big = ImmutableInputPeerPhotoFileLocationLegacy.this.bigInitialize();
                this.bigBuildStage = 1;
            }
            return this.big;
        }

        void big(boolean big) {
            this.big = big;
            this.bigBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.bigBuildStage == -1) {
                attributes.add("big");
            }
            return "Cannot build InputPeerPhotoFileLocationLegacy, attribute initializers form cycle " + attributes;
        }
    }
}

