/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputPeerSelf;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPeerSelf
implements InputPeerSelf {
    private final int identifier;
    private static final ImmutableInputPeerSelf INSTANCE = ImmutableInputPeerSelf.validate(new ImmutableInputPeerSelf());

    private ImmutableInputPeerSelf() {
        this.identifier = InputPeerSelf.super.identifier();
    }

    private ImmutableInputPeerSelf(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPeerSelf.super.identifier();
    }

    private ImmutableInputPeerSelf(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputPeerSelf withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputPeerSelf.validate(new ImmutableInputPeerSelf(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPeerSelf && this.equalTo(0, (ImmutableInputPeerSelf)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPeerSelf another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputPeerSelf{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputPeerSelf of() {
        return INSTANCE;
    }

    private static ImmutableInputPeerSelf validate(ImmutableInputPeerSelf instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputPeerSelf copyOf(InputPeerSelf instance) {
        if (instance instanceof ImmutableInputPeerSelf) {
            return (ImmutableInputPeerSelf)instance;
        }
        return ImmutableInputPeerSelf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputPeerSelf instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPeer instance;
            long bits = 0L;
            if (object instanceof InputPeerSelf) {
                instance = (InputPeerSelf)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPeer) {
                instance = (InputPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputPeerSelf build() {
            return ImmutableInputPeerSelf.validate(new ImmutableInputPeerSelf(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

