/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputPeerUser;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPeerUser
implements InputPeerUser {
    private final int identifier;
    private final long userId;
    private final long accessHash;

    private ImmutableInputPeerUser(long userId, long accessHash) {
        this.userId = userId;
        this.accessHash = accessHash;
        this.identifier = InputPeerUser.super.identifier();
    }

    private ImmutableInputPeerUser(Builder builder) {
        this.userId = builder.userId;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPeerUser.super.identifier();
    }

    private ImmutableInputPeerUser(int identifier, long userId, long accessHash) {
        this.identifier = identifier;
        this.userId = userId;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableInputPeerUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPeerUser(value, this.userId, this.accessHash);
    }

    public final ImmutableInputPeerUser withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableInputPeerUser(this.identifier, value, this.accessHash);
    }

    public final ImmutableInputPeerUser withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableInputPeerUser(this.identifier, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPeerUser && this.equalTo(0, (ImmutableInputPeerUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPeerUser another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "InputPeerUser{identifier=" + this.identifier + ", userId=" + this.userId + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableInputPeerUser of(long userId, long accessHash) {
        return new ImmutableInputPeerUser(userId, accessHash);
    }

    public static ImmutableInputPeerUser copyOf(InputPeerUser instance) {
        if (instance instanceof ImmutableInputPeerUser) {
            return (ImmutableInputPeerUser)instance;
        }
        return ImmutableInputPeerUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeerUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPeerUser) {
                instance = (InputPeerUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
                this.accessHash(instance.accessHash());
            }
            if (object instanceof InputPeer) {
                instance = (InputPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputPeerUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPeerUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build InputPeerUser, some of required attributes are not set " + attributes;
        }
    }
}

