/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputPeerUserFromMessage;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPeerUserFromMessage
implements InputPeerUserFromMessage {
    private final int identifier;
    private final InputPeer peer;
    private final int msgId;
    private final long userId;

    private ImmutableInputPeerUserFromMessage(InputPeer peer, int msgId, long userId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.userId = userId;
        this.identifier = InputPeerUserFromMessage.super.identifier();
    }

    private ImmutableInputPeerUserFromMessage(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPeerUserFromMessage.super.identifier();
    }

    private ImmutableInputPeerUserFromMessage(int identifier, InputPeer peer, int msgId, long userId) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    public final ImmutableInputPeerUserFromMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPeerUserFromMessage(value, this.peer, this.msgId, this.userId);
    }

    public final ImmutableInputPeerUserFromMessage withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableInputPeerUserFromMessage(this.identifier, newValue, this.msgId, this.userId);
    }

    public final ImmutableInputPeerUserFromMessage withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableInputPeerUserFromMessage(this.identifier, this.peer, value, this.userId);
    }

    public final ImmutableInputPeerUserFromMessage withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableInputPeerUserFromMessage(this.identifier, this.peer, this.msgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPeerUserFromMessage && this.equalTo(0, (ImmutableInputPeerUserFromMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPeerUserFromMessage another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId && this.userId == another.userId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + Long.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "InputPeerUserFromMessage{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + ", userId=" + this.userId + "}";
    }

    public static ImmutableInputPeerUserFromMessage of(InputPeer peer, int msgId, long userId) {
        return new ImmutableInputPeerUserFromMessage(peer, msgId, userId);
    }

    public static ImmutableInputPeerUserFromMessage copyOf(InputPeerUserFromMessage instance) {
        if (instance instanceof ImmutableInputPeerUserFromMessage) {
            return (ImmutableInputPeerUserFromMessage)instance;
        }
        return ImmutableInputPeerUserFromMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private int msgId;
        private long userId;

        private Builder() {
        }

        public final Builder from(InputPeerUserFromMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPeer instance;
            long bits = 0L;
            if (object instanceof InputPeerUserFromMessage) {
                instance = (InputPeerUserFromMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.userId(instance.userId());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPeer) {
                instance = (InputPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputPeerUserFromMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPeerUserFromMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build InputPeerUserFromMessage, some of required attributes are not set " + attributes;
        }
    }
}

