/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputPhoto;
import telegram4j.tl.InputPhotoEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPhotoEmpty
implements InputPhotoEmpty {
    private final int identifier;
    private static final ImmutableInputPhotoEmpty INSTANCE = ImmutableInputPhotoEmpty.validate(new ImmutableInputPhotoEmpty());

    private ImmutableInputPhotoEmpty() {
        this.identifier = InputPhotoEmpty.super.identifier();
    }

    private ImmutableInputPhotoEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPhotoEmpty.super.identifier();
    }

    private ImmutableInputPhotoEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputPhotoEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputPhotoEmpty.validate(new ImmutableInputPhotoEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPhotoEmpty && this.equalTo(0, (ImmutableInputPhotoEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPhotoEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputPhotoEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputPhotoEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputPhotoEmpty validate(ImmutableInputPhotoEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputPhotoEmpty copyOf(InputPhotoEmpty instance) {
        if (instance instanceof ImmutableInputPhotoEmpty) {
            return (ImmutableInputPhotoEmpty)instance;
        }
        return ImmutableInputPhotoEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputPhotoEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPhoto instance;
            long bits = 0L;
            if (object instanceof InputPhotoEmpty) {
                instance = (InputPhotoEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPhoto) {
                instance = (InputPhoto)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputPhotoEmpty build() {
            return ImmutableInputPhotoEmpty.validate(new ImmutableInputPhotoEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

