/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.InputPhotoLegacyFileLocation;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPhotoLegacyFileLocation
implements InputPhotoLegacyFileLocation {
    private final int identifier;
    private final long id;
    private final long accessHash;
    private final ByteBuf fileReference;
    private final long volumeId;
    private final int localId;
    private final long secret;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputPhotoLegacyFileLocation(long id, long accessHash, long volumeId, int localId, long secret) {
        this.id = id;
        this.accessHash = accessHash;
        this.volumeId = volumeId;
        this.localId = localId;
        this.secret = secret;
        this.fileReference = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputPhotoLegacyFileLocation(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.fileReference = builder.fileReference_build();
        this.volumeId = builder.volumeId;
        this.localId = builder.localId;
        this.secret = builder.secret;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputPhotoLegacyFileLocation(int identifier, long id, long accessHash, ByteBuf fileReference, long volumeId, int localId, long secret) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.fileReference = fileReference;
        this.volumeId = volumeId;
        this.localId = localId;
        this.secret = secret;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputPhotoLegacyFileLocation.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public ByteBuf fileReference() {
        return this.fileReference.duplicate();
    }

    @Override
    public long volumeId() {
        return this.volumeId;
    }

    @Override
    public int localId() {
        return this.localId;
    }

    @Override
    public long secret() {
        return this.secret;
    }

    public final ImmutableInputPhotoLegacyFileLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPhotoLegacyFileLocation(value, this.id, this.accessHash, this.fileReference, this.volumeId, this.localId, this.secret);
    }

    public final ImmutableInputPhotoLegacyFileLocation withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputPhotoLegacyFileLocation(this.identifier, value, this.accessHash, this.fileReference, this.volumeId, this.localId, this.secret);
    }

    public final ImmutableInputPhotoLegacyFileLocation withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableInputPhotoLegacyFileLocation(this.identifier, this.id, value, this.fileReference, this.volumeId, this.localId, this.secret);
    }

    public ImmutableInputPhotoLegacyFileLocation withFileReference(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileReference == newValue) {
            return this;
        }
        return new ImmutableInputPhotoLegacyFileLocation(this.identifier, this.id, this.accessHash, newValue, this.volumeId, this.localId, this.secret);
    }

    public final ImmutableInputPhotoLegacyFileLocation withVolumeId(long value) {
        if (this.volumeId == value) {
            return this;
        }
        return new ImmutableInputPhotoLegacyFileLocation(this.identifier, this.id, this.accessHash, this.fileReference, value, this.localId, this.secret);
    }

    public final ImmutableInputPhotoLegacyFileLocation withLocalId(int value) {
        if (this.localId == value) {
            return this;
        }
        return new ImmutableInputPhotoLegacyFileLocation(this.identifier, this.id, this.accessHash, this.fileReference, this.volumeId, value, this.secret);
    }

    public final ImmutableInputPhotoLegacyFileLocation withSecret(long value) {
        if (this.secret == value) {
            return this;
        }
        return new ImmutableInputPhotoLegacyFileLocation(this.identifier, this.id, this.accessHash, this.fileReference, this.volumeId, this.localId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPhotoLegacyFileLocation && this.equalTo(0, (ImmutableInputPhotoLegacyFileLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPhotoLegacyFileLocation another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.fileReference().equals((Object)another.fileReference()) && this.volumeId == another.volumeId && this.localId == another.localId && this.secret == another.secret;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.fileReference().hashCode();
        h += (h << 5) + Long.hashCode(this.volumeId);
        h += (h << 5) + this.localId;
        h += (h << 5) + Long.hashCode(this.secret);
        return h;
    }

    public String toString() {
        return "InputPhotoLegacyFileLocation{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", fileReference=" + ByteBufUtil.hexDump((ByteBuf)this.fileReference) + ", volumeId=" + this.volumeId + ", localId=" + this.localId + ", secret=" + this.secret + "}";
    }

    public static ImmutableInputPhotoLegacyFileLocation of(long id, long accessHash, long volumeId, int localId, long secret) {
        return new ImmutableInputPhotoLegacyFileLocation(id, accessHash, volumeId, localId, secret);
    }

    public static ImmutableInputPhotoLegacyFileLocation copyOf(InputPhotoLegacyFileLocation instance) {
        if (instance instanceof ImmutableInputPhotoLegacyFileLocation) {
            return (ImmutableInputPhotoLegacyFileLocation)instance;
        }
        return ImmutableInputPhotoLegacyFileLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_VOLUME_ID = 4L;
        private static final long INIT_BIT_LOCAL_ID = 8L;
        private static final long INIT_BIT_SECRET = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private ByteBuf fileReference_value = null;
        private int identifier;
        private long id;
        private long accessHash;
        private long volumeId;
        private int localId;
        private long secret;

        private Builder() {
        }

        public final Builder from(InputPhotoLegacyFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputPhotoLegacyFileLocation) {
                instance = (InputPhotoLegacyFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.volumeId(instance.volumeId());
                this.accessHash(instance.accessHash());
                this.id(instance.id());
                this.secret(instance.secret());
                this.fileReference(instance.fileReference());
                this.localId(instance.localId());
            }
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder fileReference(ByteBuf value) {
            this.fileReference_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder volumeId(long volumeId) {
            this.volumeId = volumeId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder localId(int localId) {
            this.localId = localId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder secret(long secret) {
            this.secret = secret;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableInputPhotoLegacyFileLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputPhotoLegacyFileLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("volumeId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("localId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("secret");
            }
            return "Cannot build InputPhotoLegacyFileLocation, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileReference_build() {
            return Objects.requireNonNull(this.fileReference_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputPhotoLegacyFileLocation.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build InputPhotoLegacyFileLocation, attribute initializers form cycle " + attributes;
        }
    }
}

