/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputPrivacyRule;
import telegram4j.tl.InputPrivacyValueAllowAll;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPrivacyValueAllowAll
implements InputPrivacyValueAllowAll {
    private final int identifier;
    private static final ImmutableInputPrivacyValueAllowAll INSTANCE = ImmutableInputPrivacyValueAllowAll.validate(new ImmutableInputPrivacyValueAllowAll());

    private ImmutableInputPrivacyValueAllowAll() {
        this.identifier = InputPrivacyValueAllowAll.super.identifier();
    }

    private ImmutableInputPrivacyValueAllowAll(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPrivacyValueAllowAll.super.identifier();
    }

    private ImmutableInputPrivacyValueAllowAll(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputPrivacyValueAllowAll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputPrivacyValueAllowAll.validate(new ImmutableInputPrivacyValueAllowAll(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPrivacyValueAllowAll && this.equalTo(0, (ImmutableInputPrivacyValueAllowAll)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPrivacyValueAllowAll another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputPrivacyValueAllowAll{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputPrivacyValueAllowAll of() {
        return INSTANCE;
    }

    private static ImmutableInputPrivacyValueAllowAll validate(ImmutableInputPrivacyValueAllowAll instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputPrivacyValueAllowAll copyOf(InputPrivacyValueAllowAll instance) {
        if (instance instanceof ImmutableInputPrivacyValueAllowAll) {
            return (ImmutableInputPrivacyValueAllowAll)instance;
        }
        return ImmutableInputPrivacyValueAllowAll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputPrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPrivacyValueAllowAll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPrivacyRule instance;
            long bits = 0L;
            if (object instanceof InputPrivacyRule) {
                instance = (InputPrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPrivacyValueAllowAll) {
                instance = (InputPrivacyValueAllowAll)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputPrivacyValueAllowAll build() {
            return ImmutableInputPrivacyValueAllowAll.validate(new ImmutableInputPrivacyValueAllowAll(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

