/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPrivacyRule;
import telegram4j.tl.InputPrivacyValueAllowChatParticipants;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPrivacyValueAllowChatParticipants
implements InputPrivacyValueAllowChatParticipants {
    private final int identifier;
    private final List<Long> chats;

    private ImmutableInputPrivacyValueAllowChatParticipants(Builder builder) {
        this.chats = ImmutableInputPrivacyValueAllowChatParticipants.createUnmodifiableList(true, builder.chats);
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPrivacyValueAllowChatParticipants.super.identifier();
    }

    private ImmutableInputPrivacyValueAllowChatParticipants(int identifier, List<Long> chats) {
        this.identifier = identifier;
        this.chats = chats;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> chats() {
        return this.chats;
    }

    public final ImmutableInputPrivacyValueAllowChatParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPrivacyValueAllowChatParticipants(value, this.chats);
    }

    public final ImmutableInputPrivacyValueAllowChatParticipants withChats(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableInputPrivacyValueAllowChatParticipants.createUnmodifiableList(false, wrappedList);
        return new ImmutableInputPrivacyValueAllowChatParticipants(this.identifier, newValue);
    }

    public final ImmutableInputPrivacyValueAllowChatParticipants withChats(Iterable<Long> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Long> newValue = ImmutableInputPrivacyValueAllowChatParticipants.createUnmodifiableList(false, ImmutableInputPrivacyValueAllowChatParticipants.createSafeList(elements, true, false));
        return new ImmutableInputPrivacyValueAllowChatParticipants(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPrivacyValueAllowChatParticipants && this.equalTo(0, (ImmutableInputPrivacyValueAllowChatParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPrivacyValueAllowChatParticipants another) {
        return this.identifier == another.identifier && this.chats.equals(another.chats);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chats.hashCode();
        return h;
    }

    public String toString() {
        return "InputPrivacyValueAllowChatParticipants{identifier=" + this.identifier + ", chats=" + this.chats + "}";
    }

    public static ImmutableInputPrivacyValueAllowChatParticipants copyOf(InputPrivacyValueAllowChatParticipants instance) {
        if (instance instanceof ImmutableInputPrivacyValueAllowChatParticipants) {
            return (ImmutableInputPrivacyValueAllowChatParticipants)instance;
        }
        return ImmutableInputPrivacyValueAllowChatParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> chats = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(InputPrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPrivacyValueAllowChatParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPrivacyRule instance;
            long bits = 0L;
            if (object instanceof InputPrivacyRule) {
                instance = (InputPrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPrivacyValueAllowChatParticipants) {
                instance = (InputPrivacyValueAllowChatParticipants)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addChat(long element) {
            this.chats.add(element);
            return this;
        }

        public final Builder addChats(long ... elements) {
            for (long element : elements) {
                this.chats.add(element);
            }
            return this;
        }

        public final Builder chats(Iterable<Long> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<Long> elements) {
            for (Long element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public ImmutableInputPrivacyValueAllowChatParticipants build() {
            return new ImmutableInputPrivacyValueAllowChatParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

