/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputPrivacyRule;
import telegram4j.tl.InputPrivacyValueAllowContacts;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPrivacyValueAllowContacts
implements InputPrivacyValueAllowContacts {
    private final int identifier;
    private static final ImmutableInputPrivacyValueAllowContacts INSTANCE = ImmutableInputPrivacyValueAllowContacts.validate(new ImmutableInputPrivacyValueAllowContacts());

    private ImmutableInputPrivacyValueAllowContacts() {
        this.identifier = InputPrivacyValueAllowContacts.super.identifier();
    }

    private ImmutableInputPrivacyValueAllowContacts(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPrivacyValueAllowContacts.super.identifier();
    }

    private ImmutableInputPrivacyValueAllowContacts(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputPrivacyValueAllowContacts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputPrivacyValueAllowContacts.validate(new ImmutableInputPrivacyValueAllowContacts(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPrivacyValueAllowContacts && this.equalTo(0, (ImmutableInputPrivacyValueAllowContacts)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPrivacyValueAllowContacts another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputPrivacyValueAllowContacts{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputPrivacyValueAllowContacts of() {
        return INSTANCE;
    }

    private static ImmutableInputPrivacyValueAllowContacts validate(ImmutableInputPrivacyValueAllowContacts instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputPrivacyValueAllowContacts copyOf(InputPrivacyValueAllowContacts instance) {
        if (instance instanceof ImmutableInputPrivacyValueAllowContacts) {
            return (ImmutableInputPrivacyValueAllowContacts)instance;
        }
        return ImmutableInputPrivacyValueAllowContacts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputPrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPrivacyValueAllowContacts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPrivacyRule instance;
            long bits = 0L;
            if (object instanceof InputPrivacyRule) {
                instance = (InputPrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPrivacyValueAllowContacts) {
                instance = (InputPrivacyValueAllowContacts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputPrivacyValueAllowContacts build() {
            return ImmutableInputPrivacyValueAllowContacts.validate(new ImmutableInputPrivacyValueAllowContacts(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

