/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPrivacyRule;
import telegram4j.tl.InputPrivacyValueAllowUsers;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPrivacyValueAllowUsers
implements InputPrivacyValueAllowUsers {
    private final int identifier;
    private final List<InputUser> users;

    private ImmutableInputPrivacyValueAllowUsers(Builder builder) {
        this.users = ImmutableInputPrivacyValueAllowUsers.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPrivacyValueAllowUsers.super.identifier();
    }

    private ImmutableInputPrivacyValueAllowUsers(int identifier, List<InputUser> users) {
        this.identifier = identifier;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputUser> users() {
        return this.users;
    }

    public final ImmutableInputPrivacyValueAllowUsers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputPrivacyValueAllowUsers(value, this.users);
    }

    public final ImmutableInputPrivacyValueAllowUsers withUsers(InputUser ... elements) {
        List<InputUser> newValue = ImmutableInputPrivacyValueAllowUsers.createUnmodifiableList(false, ImmutableInputPrivacyValueAllowUsers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputPrivacyValueAllowUsers(this.identifier, newValue);
    }

    public final ImmutableInputPrivacyValueAllowUsers withUsers(Iterable<? extends InputUser> elements) {
        if (this.users == elements) {
            return this;
        }
        List<InputUser> newValue = ImmutableInputPrivacyValueAllowUsers.createUnmodifiableList(false, ImmutableInputPrivacyValueAllowUsers.createSafeList(elements, true, false));
        return new ImmutableInputPrivacyValueAllowUsers(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPrivacyValueAllowUsers && this.equalTo(0, (ImmutableInputPrivacyValueAllowUsers)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPrivacyValueAllowUsers another) {
        return this.identifier == another.identifier && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "InputPrivacyValueAllowUsers{identifier=" + this.identifier + ", users=" + this.users + "}";
    }

    public static ImmutableInputPrivacyValueAllowUsers copyOf(InputPrivacyValueAllowUsers instance) {
        if (instance instanceof ImmutableInputPrivacyValueAllowUsers) {
            return (ImmutableInputPrivacyValueAllowUsers)instance;
        }
        return ImmutableInputPrivacyValueAllowUsers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputUser> users = new ArrayList<InputUser>();

        private Builder() {
        }

        public final Builder from(InputPrivacyValueAllowUsers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPrivacyRule instance;
            long bits = 0L;
            if (object instanceof InputPrivacyValueAllowUsers) {
                instance = (InputPrivacyValueAllowUsers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof InputPrivacyRule) {
                instance = (InputPrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addUser(InputUser element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(InputUser ... elements) {
            for (InputUser element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends InputUser> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends InputUser> elements) {
            for (InputUser inputUser : elements) {
                this.users.add(Objects.requireNonNull(inputUser, "users element"));
            }
            return this;
        }

        public ImmutableInputPrivacyValueAllowUsers build() {
            return new ImmutableInputPrivacyValueAllowUsers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

