/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputPrivacyRule;
import telegram4j.tl.InputPrivacyValueDisallowAll;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputPrivacyValueDisallowAll
implements InputPrivacyValueDisallowAll {
    private final int identifier;
    private static final ImmutableInputPrivacyValueDisallowAll INSTANCE = ImmutableInputPrivacyValueDisallowAll.validate(new ImmutableInputPrivacyValueDisallowAll());

    private ImmutableInputPrivacyValueDisallowAll() {
        this.identifier = InputPrivacyValueDisallowAll.super.identifier();
    }

    private ImmutableInputPrivacyValueDisallowAll(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputPrivacyValueDisallowAll.super.identifier();
    }

    private ImmutableInputPrivacyValueDisallowAll(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputPrivacyValueDisallowAll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputPrivacyValueDisallowAll.validate(new ImmutableInputPrivacyValueDisallowAll(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputPrivacyValueDisallowAll && this.equalTo(0, (ImmutableInputPrivacyValueDisallowAll)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputPrivacyValueDisallowAll another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputPrivacyValueDisallowAll{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputPrivacyValueDisallowAll of() {
        return INSTANCE;
    }

    private static ImmutableInputPrivacyValueDisallowAll validate(ImmutableInputPrivacyValueDisallowAll instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputPrivacyValueDisallowAll copyOf(InputPrivacyValueDisallowAll instance) {
        if (instance instanceof ImmutableInputPrivacyValueDisallowAll) {
            return (ImmutableInputPrivacyValueDisallowAll)instance;
        }
        return ImmutableInputPrivacyValueDisallowAll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputPrivacyValueDisallowAll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputPrivacyRule instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPrivacyRule instance;
            long bits = 0L;
            if (object instanceof InputPrivacyValueDisallowAll) {
                instance = (InputPrivacyValueDisallowAll)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputPrivacyRule) {
                instance = (InputPrivacyRule)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputPrivacyValueDisallowAll build() {
            return ImmutableInputPrivacyValueDisallowAll.validate(new ImmutableInputPrivacyValueDisallowAll(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

