/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputSecureFile;
import telegram4j.tl.InputSecureFileUploaded;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputSecureFileUploaded
implements InputSecureFileUploaded {
    private final int identifier;
    private final long id;
    private final int parts;
    private final String md5Checksum;
    private final ByteBuf fileHash;
    private final ByteBuf secret;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputSecureFileUploaded(long id, int parts, String md5Checksum) {
        this.id = id;
        this.parts = parts;
        this.md5Checksum = Objects.requireNonNull(md5Checksum, "md5Checksum");
        this.fileHash = null;
        this.secret = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputSecureFileUploaded(Builder builder) {
        this.id = builder.id;
        this.parts = builder.parts;
        this.md5Checksum = builder.md5Checksum;
        this.fileHash = builder.fileHash_build();
        this.secret = builder.secret_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableInputSecureFileUploaded(int identifier, long id, int parts, String md5Checksum, ByteBuf fileHash, ByteBuf secret) {
        this.identifier = identifier;
        this.id = id;
        this.parts = parts;
        this.md5Checksum = md5Checksum;
        this.fileHash = fileHash;
        this.secret = secret;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputSecureFileUploaded.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int parts() {
        return this.parts;
    }

    @Override
    public String md5Checksum() {
        return this.md5Checksum;
    }

    @Override
    public ByteBuf fileHash() {
        return this.fileHash.duplicate();
    }

    @Override
    public ByteBuf secret() {
        return this.secret.duplicate();
    }

    public final ImmutableInputSecureFileUploaded withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputSecureFileUploaded(value, this.id, this.parts, this.md5Checksum, this.fileHash, this.secret);
    }

    public final ImmutableInputSecureFileUploaded withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableInputSecureFileUploaded(this.identifier, value, this.parts, this.md5Checksum, this.fileHash, this.secret);
    }

    public final ImmutableInputSecureFileUploaded withParts(int value) {
        if (this.parts == value) {
            return this;
        }
        return new ImmutableInputSecureFileUploaded(this.identifier, this.id, value, this.md5Checksum, this.fileHash, this.secret);
    }

    public final ImmutableInputSecureFileUploaded withMd5Checksum(String value) {
        String newValue = Objects.requireNonNull(value, "md5Checksum");
        if (this.md5Checksum.equals(newValue)) {
            return this;
        }
        return new ImmutableInputSecureFileUploaded(this.identifier, this.id, this.parts, newValue, this.fileHash, this.secret);
    }

    public ImmutableInputSecureFileUploaded withFileHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileHash == newValue) {
            return this;
        }
        return new ImmutableInputSecureFileUploaded(this.identifier, this.id, this.parts, this.md5Checksum, newValue, this.secret);
    }

    public ImmutableInputSecureFileUploaded withSecret(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secret == newValue) {
            return this;
        }
        return new ImmutableInputSecureFileUploaded(this.identifier, this.id, this.parts, this.md5Checksum, this.fileHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputSecureFileUploaded && this.equalTo(0, (ImmutableInputSecureFileUploaded)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputSecureFileUploaded another) {
        return this.identifier == another.identifier && this.id == another.id && this.parts == another.parts && this.md5Checksum.equals(another.md5Checksum) && this.fileHash().equals((Object)another.fileHash()) && this.secret().equals((Object)another.secret());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.parts;
        h += (h << 5) + this.md5Checksum.hashCode();
        h += (h << 5) + this.fileHash().hashCode();
        h += (h << 5) + this.secret().hashCode();
        return h;
    }

    public String toString() {
        return "InputSecureFileUploaded{identifier=" + this.identifier + ", id=" + this.id + ", parts=" + this.parts + ", md5Checksum=" + this.md5Checksum + ", fileHash=" + ByteBufUtil.hexDump((ByteBuf)this.fileHash) + ", secret=" + ByteBufUtil.hexDump((ByteBuf)this.secret) + "}";
    }

    public static ImmutableInputSecureFileUploaded of(long id, int parts, String md5Checksum) {
        return new ImmutableInputSecureFileUploaded(id, parts, md5Checksum);
    }

    public static ImmutableInputSecureFileUploaded copyOf(InputSecureFileUploaded instance) {
        if (instance instanceof ImmutableInputSecureFileUploaded) {
            return (ImmutableInputSecureFileUploaded)instance;
        }
        return ImmutableInputSecureFileUploaded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PARTS = 2L;
        private static final long INIT_BIT_MD5_CHECKSUM = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf fileHash_value = null;
        private ByteBuf secret_value = null;
        private int identifier;
        private long id;
        private int parts;
        private String md5Checksum;

        private Builder() {
        }

        public final Builder from(InputSecureFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputSecureFileUploaded instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputSecureFile instance;
            long bits = 0L;
            if (object instanceof InputSecureFile) {
                instance = (InputSecureFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof InputSecureFileUploaded) {
                instance = (InputSecureFileUploaded)object;
                this.md5Checksum(instance.md5Checksum());
                this.parts(instance.parts());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fileHash(instance.fileHash());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.secret(instance.secret());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder parts(int parts) {
            this.parts = parts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder md5Checksum(String md5Checksum) {
            this.md5Checksum = Objects.requireNonNull(md5Checksum, "md5Checksum");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder fileHash(ByteBuf value) {
            this.fileHash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder secret(ByteBuf value) {
            this.secret_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableInputSecureFileUploaded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputSecureFileUploaded(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("parts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("md5Checksum");
            }
            return "Cannot build InputSecureFileUploaded, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileHash_build() {
            return Objects.requireNonNull(this.fileHash_value);
        }

        private ByteBuf secret_build() {
            return Objects.requireNonNull(this.secret_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputSecureFileUploaded.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build InputSecureFileUploaded, attribute initializers form cycle " + attributes;
        }
    }
}

