/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputSecureFile;
import telegram4j.tl.InputSecureValue;
import telegram4j.tl.SecureData;
import telegram4j.tl.SecurePlainData;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputSecureValue
implements InputSecureValue {
    private final int identifier;
    private final int flags;
    private final SecureValueType type;
    @Nullable
    private final SecureData data;
    @Nullable
    private final InputSecureFile frontSide;
    @Nullable
    private final InputSecureFile reverseSide;
    @Nullable
    private final InputSecureFile selfie;
    @Nullable
    private final List<InputSecureFile> translation;
    @Nullable
    private final List<InputSecureFile> files;
    @Nullable
    private final SecurePlainData plainData;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputSecureValue(SecureValueType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.data = null;
        this.frontSide = null;
        this.reverseSide = null;
        this.selfie = null;
        this.translation = null;
        this.files = null;
        this.plainData = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputSecureValue(Builder builder) {
        this.type = builder.type;
        this.data = builder.data;
        this.frontSide = builder.frontSide;
        this.reverseSide = builder.reverseSide;
        this.selfie = builder.selfie;
        this.translation = builder.translation == null ? null : ImmutableInputSecureValue.createUnmodifiableList(true, builder.translation);
        this.files = builder.files == null ? null : ImmutableInputSecureValue.createUnmodifiableList(true, builder.files);
        this.plainData = builder.plainData;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputSecureValue(int identifier, int flags, SecureValueType type, @Nullable SecureData data, @Nullable InputSecureFile frontSide, @Nullable InputSecureFile reverseSide, @Nullable InputSecureFile selfie, @Nullable List<InputSecureFile> translation, @Nullable List<InputSecureFile> files, @Nullable SecurePlainData plainData) {
        this.identifier = identifier;
        this.flags = flags;
        this.type = type;
        this.data = data;
        this.frontSide = frontSide;
        this.reverseSide = reverseSide;
        this.selfie = selfie;
        this.translation = translation;
        this.files = files;
        this.plainData = plainData;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputSecureValue.super.identifier();
    }

    private int flagsInitialize() {
        return InputSecureValue.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public SecureValueType type() {
        return this.type;
    }

    @Override
    @Nullable
    public SecureData data() {
        return this.data;
    }

    @Override
    @Nullable
    public InputSecureFile frontSide() {
        return this.frontSide;
    }

    @Override
    @Nullable
    public InputSecureFile reverseSide() {
        return this.reverseSide;
    }

    @Override
    @Nullable
    public InputSecureFile selfie() {
        return this.selfie;
    }

    @Override
    @Nullable
    public List<InputSecureFile> translation() {
        return this.translation;
    }

    @Override
    @Nullable
    public List<InputSecureFile> files() {
        return this.files;
    }

    @Override
    @Nullable
    public SecurePlainData plainData() {
        return this.plainData;
    }

    public final ImmutableInputSecureValue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputSecureValue(value, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputSecureValue(this.identifier, value, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withType(SecureValueType value) {
        SecureValueType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableInputSecureValue(this.identifier, this.flags, newValue, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withData(@Nullable SecureData value) {
        if (this.data == value) {
            return this;
        }
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, value, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withFrontSide(@Nullable InputSecureFile value) {
        if (this.frontSide == value) {
            return this;
        }
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, value, this.reverseSide, this.selfie, this.translation, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withReverseSide(@Nullable InputSecureFile value) {
        if (this.reverseSide == value) {
            return this;
        }
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, value, this.selfie, this.translation, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withSelfie(@Nullable InputSecureFile value) {
        if (this.selfie == value) {
            return this;
        }
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, value, this.translation, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withTranslation(InputSecureFile ... elements) {
        if (elements == null) {
            return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, null, this.files, this.plainData);
        }
        List<InputSecureFile> newValue = Arrays.asList(elements) == null ? null : ImmutableInputSecureValue.createUnmodifiableList(false, ImmutableInputSecureValue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, newValue, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withTranslation(@Nullable Iterable<? extends InputSecureFile> elements) {
        if (this.translation == elements) {
            return this;
        }
        List<InputSecureFile> newValue = elements == null ? null : ImmutableInputSecureValue.createUnmodifiableList(false, ImmutableInputSecureValue.createSafeList(elements, true, false));
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, newValue, this.files, this.plainData);
    }

    public final ImmutableInputSecureValue withFiles(InputSecureFile ... elements) {
        if (elements == null) {
            return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, null, this.plainData);
        }
        List<InputSecureFile> newValue = Arrays.asList(elements) == null ? null : ImmutableInputSecureValue.createUnmodifiableList(false, ImmutableInputSecureValue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, newValue, this.plainData);
    }

    public final ImmutableInputSecureValue withFiles(@Nullable Iterable<? extends InputSecureFile> elements) {
        if (this.files == elements) {
            return this;
        }
        List<InputSecureFile> newValue = elements == null ? null : ImmutableInputSecureValue.createUnmodifiableList(false, ImmutableInputSecureValue.createSafeList(elements, true, false));
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, newValue, this.plainData);
    }

    public final ImmutableInputSecureValue withPlainData(@Nullable SecurePlainData value) {
        if (this.plainData == value) {
            return this;
        }
        return new ImmutableInputSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputSecureValue && this.equalTo(0, (ImmutableInputSecureValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputSecureValue another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.type.equals((Object)another.type) && Objects.equals(this.data, another.data) && Objects.equals(this.frontSide, another.frontSide) && Objects.equals(this.reverseSide, another.reverseSide) && Objects.equals(this.selfie, another.selfie) && Objects.equals(this.translation, another.translation) && Objects.equals(this.files, another.files) && Objects.equals(this.plainData, another.plainData);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.frontSide);
        h += (h << 5) + Objects.hashCode(this.reverseSide);
        h += (h << 5) + Objects.hashCode(this.selfie);
        h += (h << 5) + Objects.hashCode(this.translation);
        h += (h << 5) + Objects.hashCode(this.files);
        h += (h << 5) + Objects.hashCode(this.plainData);
        return h;
    }

    public String toString() {
        return "InputSecureValue{identifier=" + this.identifier + ", flags=" + this.flags + ", type=" + this.type + ", data=" + this.data + ", frontSide=" + this.frontSide + ", reverseSide=" + this.reverseSide + ", selfie=" + this.selfie + ", translation=" + this.translation + ", files=" + this.files + ", plainData=" + this.plainData + "}";
    }

    public static ImmutableInputSecureValue of(SecureValueType type) {
        return new ImmutableInputSecureValue(type);
    }

    public static ImmutableInputSecureValue copyOf(InputSecureValue instance) {
        if (instance instanceof ImmutableInputSecureValue) {
            return (ImmutableInputSecureValue)instance;
        }
        return ImmutableInputSecureValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private SecureValueType type;
        private SecureData data;
        private InputSecureFile frontSide;
        private InputSecureFile reverseSide;
        private InputSecureFile selfie;
        private List<InputSecureFile> translation = null;
        private List<InputSecureFile> files = null;
        private SecurePlainData plainData;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputSecureValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputSecureValue) {
                List<InputSecureFile> filesValue;
                InputSecureFile selfieValue;
                InputSecureFile reverseSideValue;
                SecureData dataValue;
                SecurePlainData plainDataValue;
                instance = (InputSecureValue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((plainDataValue = instance.plainData()) != null) {
                    this.plainData(plainDataValue);
                }
                if ((dataValue = instance.data()) != null) {
                    this.data(dataValue);
                }
                if ((reverseSideValue = instance.reverseSide()) != null) {
                    this.reverseSide(reverseSideValue);
                }
                if ((selfieValue = instance.selfie()) != null) {
                    this.selfie(selfieValue);
                }
                this.flags(instance.flags());
                List<InputSecureFile> translationValue = instance.translation();
                if (translationValue != null) {
                    this.addAllTranslation(translationValue);
                }
                if ((filesValue = instance.files()) != null) {
                    this.addAllFiles(filesValue);
                }
                this.type(instance.type());
                InputSecureFile frontSideValue = instance.frontSide();
                if (frontSideValue != null) {
                    this.frontSide(frontSideValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder type(SecureValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder data(@Nullable SecureData data) {
            this.data = data;
            return this;
        }

        public final Builder frontSide(@Nullable InputSecureFile frontSide) {
            this.frontSide = frontSide;
            return this;
        }

        public final Builder reverseSide(@Nullable InputSecureFile reverseSide) {
            this.reverseSide = reverseSide;
            return this;
        }

        public final Builder selfie(@Nullable InputSecureFile selfie) {
            this.selfie = selfie;
            return this;
        }

        public final Builder addTranslation(InputSecureFile element) {
            if (this.translation == null) {
                this.translation = new ArrayList<InputSecureFile>();
            }
            this.translation.add(Objects.requireNonNull(element, "translation element"));
            return this;
        }

        public final Builder addTranslation(InputSecureFile ... elements) {
            if (this.translation == null) {
                this.translation = new ArrayList<InputSecureFile>();
            }
            for (InputSecureFile element : elements) {
                this.translation.add(Objects.requireNonNull(element, "translation element"));
            }
            return this;
        }

        public final Builder translation(@Nullable Iterable<? extends InputSecureFile> elements) {
            if (elements == null) {
                this.translation = null;
                return this;
            }
            this.translation = new ArrayList<InputSecureFile>();
            return this.addAllTranslation(elements);
        }

        public final Builder addAllTranslation(Iterable<? extends InputSecureFile> elements) {
            Objects.requireNonNull(elements, "translation element");
            if (this.translation == null) {
                this.translation = new ArrayList<InputSecureFile>();
            }
            for (InputSecureFile inputSecureFile : elements) {
                this.translation.add(Objects.requireNonNull(inputSecureFile, "translation element"));
            }
            return this;
        }

        public final Builder addFile(InputSecureFile element) {
            if (this.files == null) {
                this.files = new ArrayList<InputSecureFile>();
            }
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        public final Builder addFiles(InputSecureFile ... elements) {
            if (this.files == null) {
                this.files = new ArrayList<InputSecureFile>();
            }
            for (InputSecureFile element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        public final Builder files(@Nullable Iterable<? extends InputSecureFile> elements) {
            if (elements == null) {
                this.files = null;
                return this;
            }
            this.files = new ArrayList<InputSecureFile>();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends InputSecureFile> elements) {
            Objects.requireNonNull(elements, "files element");
            if (this.files == null) {
                this.files = new ArrayList<InputSecureFile>();
            }
            for (InputSecureFile inputSecureFile : elements) {
                this.files.add(Objects.requireNonNull(inputSecureFile, "files element"));
            }
            return this;
        }

        public final Builder plainData(@Nullable SecurePlainData plainData) {
            this.plainData = plainData;
            return this;
        }

        public ImmutableInputSecureValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputSecureValue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build InputSecureValue, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputSecureValue.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputSecureValue.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputSecureValue, attribute initializers form cycle " + attributes;
        }
    }
}

