/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputMedia;
import telegram4j.tl.InputSingleMedia;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputSingleMedia
implements InputSingleMedia {
    private final int identifier;
    private final int flags;
    private final InputMedia media;
    private final long randomId;
    private final String message;
    @Nullable
    private final List<MessageEntity> entities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInputSingleMedia(InputMedia media, long randomId, String message) {
        this.media = Objects.requireNonNull(media, "media");
        this.randomId = randomId;
        this.message = Objects.requireNonNull(message, "message");
        this.entities = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputSingleMedia(Builder builder) {
        this.media = builder.media;
        this.randomId = builder.randomId;
        this.message = builder.message;
        List<MessageEntity> list = this.entities = builder.entities == null ? null : ImmutableInputSingleMedia.createUnmodifiableList(true, builder.entities);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInputSingleMedia(int identifier, int flags, InputMedia media, long randomId, String message, @Nullable List<MessageEntity> entities) {
        this.identifier = identifier;
        this.flags = flags;
        this.media = media;
        this.randomId = randomId;
        this.message = message;
        this.entities = entities;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputSingleMedia.super.identifier();
    }

    private int flagsInitialize() {
        return InputSingleMedia.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputMedia media() {
        return this.media;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    public final ImmutableInputSingleMedia withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputSingleMedia(value, this.flags, this.media, this.randomId, this.message, this.entities);
    }

    public final ImmutableInputSingleMedia withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInputSingleMedia(this.identifier, value, this.media, this.randomId, this.message, this.entities);
    }

    public final ImmutableInputSingleMedia withMedia(InputMedia value) {
        if (this.media == value) {
            return this;
        }
        InputMedia newValue = Objects.requireNonNull(value, "media");
        return new ImmutableInputSingleMedia(this.identifier, this.flags, newValue, this.randomId, this.message, this.entities);
    }

    public final ImmutableInputSingleMedia withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableInputSingleMedia(this.identifier, this.flags, this.media, value, this.message, this.entities);
    }

    public final ImmutableInputSingleMedia withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableInputSingleMedia(this.identifier, this.flags, this.media, this.randomId, newValue, this.entities);
    }

    public final ImmutableInputSingleMedia withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableInputSingleMedia(this.identifier, this.flags, this.media, this.randomId, this.message, null);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableInputSingleMedia.createUnmodifiableList(false, ImmutableInputSingleMedia.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputSingleMedia(this.identifier, this.flags, this.media, this.randomId, this.message, newValue);
    }

    public final ImmutableInputSingleMedia withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableInputSingleMedia.createUnmodifiableList(false, ImmutableInputSingleMedia.createSafeList(elements, true, false));
        return new ImmutableInputSingleMedia(this.identifier, this.flags, this.media, this.randomId, this.message, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputSingleMedia && this.equalTo(0, (ImmutableInputSingleMedia)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputSingleMedia another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.media.equals(another.media) && this.randomId == another.randomId && this.message.equals(another.message) && Objects.equals(this.entities, another.entities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.media.hashCode();
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.entities);
        return h;
    }

    public String toString() {
        return "InputSingleMedia{identifier=" + this.identifier + ", flags=" + this.flags + ", media=" + this.media + ", randomId=" + this.randomId + ", message=" + this.message + ", entities=" + this.entities + "}";
    }

    public static ImmutableInputSingleMedia of(InputMedia media, long randomId, String message) {
        return new ImmutableInputSingleMedia(media, randomId, message);
    }

    public static ImmutableInputSingleMedia copyOf(InputSingleMedia instance) {
        if (instance instanceof ImmutableInputSingleMedia) {
            return (ImmutableInputSingleMedia)instance;
        }
        return ImmutableInputSingleMedia.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MEDIA = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputMedia media;
        private long randomId;
        private String message;
        private List<MessageEntity> entities = null;

        private Builder() {
        }

        public final Builder from(InputSingleMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputSingleMedia instance;
            long bits = 0L;
            if (object instanceof InputSingleMedia) {
                instance = (InputSingleMedia)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                this.media(instance.media());
                this.message(instance.message());
                List<MessageEntity> entitiesValue = instance.entities();
                if (entitiesValue != null) {
                    this.addAllEntities(entitiesValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder media(InputMedia media) {
            this.media = Objects.requireNonNull(media, "media");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public ImmutableInputSingleMedia build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputSingleMedia(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("media");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build InputSingleMedia, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputSingleMedia.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputSingleMedia.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InputSingleMedia, attribute initializers form cycle " + attributes;
        }
    }
}

