/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.InputStickerSetDice;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStickerSetDice
implements InputStickerSetDice {
    private final int identifier;
    private final String emoticon;

    private ImmutableInputStickerSetDice(String emoticon) {
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.identifier = InputStickerSetDice.super.identifier();
    }

    private ImmutableInputStickerSetDice(Builder builder) {
        this.emoticon = builder.emoticon;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStickerSetDice.super.identifier();
    }

    private ImmutableInputStickerSetDice(int identifier, String emoticon) {
        this.identifier = identifier;
        this.emoticon = emoticon;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    public final ImmutableInputStickerSetDice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputStickerSetDice(value, this.emoticon);
    }

    public final ImmutableInputStickerSetDice withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableInputStickerSetDice(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStickerSetDice && this.equalTo(0, (ImmutableInputStickerSetDice)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStickerSetDice another) {
        return this.identifier == another.identifier && this.emoticon.equals(another.emoticon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emoticon.hashCode();
        return h;
    }

    public String toString() {
        return "InputStickerSetDice{identifier=" + this.identifier + ", emoticon=" + this.emoticon + "}";
    }

    public static ImmutableInputStickerSetDice of(String emoticon) {
        return new ImmutableInputStickerSetDice(emoticon);
    }

    public static ImmutableInputStickerSetDice copyOf(InputStickerSetDice instance) {
        if (instance instanceof ImmutableInputStickerSetDice) {
            return (ImmutableInputStickerSetDice)instance;
        }
        return ImmutableInputStickerSetDice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOTICON = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String emoticon;

        private Builder() {
        }

        public final Builder from(InputStickerSetDice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputStickerSet instance;
            long bits = 0L;
            if (object instanceof InputStickerSetDice) {
                instance = (InputStickerSetDice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.emoticon(instance.emoticon());
            }
            if (object instanceof InputStickerSet) {
                instance = (InputStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputStickerSetDice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputStickerSetDice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoticon");
            }
            return "Cannot build InputStickerSetDice, some of required attributes are not set " + attributes;
        }
    }
}

