/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.InputStickerSetEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStickerSetEmpty
implements InputStickerSetEmpty {
    private final int identifier;
    private static final ImmutableInputStickerSetEmpty INSTANCE = ImmutableInputStickerSetEmpty.validate(new ImmutableInputStickerSetEmpty());

    private ImmutableInputStickerSetEmpty() {
        this.identifier = InputStickerSetEmpty.super.identifier();
    }

    private ImmutableInputStickerSetEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStickerSetEmpty.super.identifier();
    }

    private ImmutableInputStickerSetEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputStickerSetEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputStickerSetEmpty.validate(new ImmutableInputStickerSetEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStickerSetEmpty && this.equalTo(0, (ImmutableInputStickerSetEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStickerSetEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputStickerSetEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputStickerSetEmpty of() {
        return INSTANCE;
    }

    private static ImmutableInputStickerSetEmpty validate(ImmutableInputStickerSetEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputStickerSetEmpty copyOf(InputStickerSetEmpty instance) {
        if (instance instanceof ImmutableInputStickerSetEmpty) {
            return (ImmutableInputStickerSetEmpty)instance;
        }
        return ImmutableInputStickerSetEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputStickerSetEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputStickerSet instance;
            long bits = 0L;
            if (object instanceof InputStickerSetEmpty) {
                instance = (InputStickerSetEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStickerSet) {
                instance = (InputStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputStickerSetEmpty build() {
            return ImmutableInputStickerSetEmpty.validate(new ImmutableInputStickerSetEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

