/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.InputStickerSetShortName;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStickerSetShortName
implements InputStickerSetShortName {
    private final int identifier;
    private final String shortName;

    private ImmutableInputStickerSetShortName(String shortName) {
        this.shortName = Objects.requireNonNull(shortName, "shortName");
        this.identifier = InputStickerSetShortName.super.identifier();
    }

    private ImmutableInputStickerSetShortName(Builder builder) {
        this.shortName = builder.shortName;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStickerSetShortName.super.identifier();
    }

    private ImmutableInputStickerSetShortName(int identifier, String shortName) {
        this.identifier = identifier;
        this.shortName = shortName;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    public final ImmutableInputStickerSetShortName withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputStickerSetShortName(value, this.shortName);
    }

    public final ImmutableInputStickerSetShortName withShortName(String value) {
        String newValue = Objects.requireNonNull(value, "shortName");
        if (this.shortName.equals(newValue)) {
            return this;
        }
        return new ImmutableInputStickerSetShortName(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStickerSetShortName && this.equalTo(0, (ImmutableInputStickerSetShortName)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStickerSetShortName another) {
        return this.identifier == another.identifier && this.shortName.equals(another.shortName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.shortName.hashCode();
        return h;
    }

    public String toString() {
        return "InputStickerSetShortName{identifier=" + this.identifier + ", shortName=" + this.shortName + "}";
    }

    public static ImmutableInputStickerSetShortName of(String shortName) {
        return new ImmutableInputStickerSetShortName(shortName);
    }

    public static ImmutableInputStickerSetShortName copyOf(InputStickerSetShortName instance) {
        if (instance instanceof ImmutableInputStickerSetShortName) {
            return (ImmutableInputStickerSetShortName)instance;
        }
        return ImmutableInputStickerSetShortName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SHORT_NAME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String shortName;

        private Builder() {
        }

        public final Builder from(InputStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStickerSetShortName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputStickerSet instance;
            long bits = 0L;
            if (object instanceof InputStickerSet) {
                instance = (InputStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStickerSetShortName) {
                instance = (InputStickerSetShortName)object;
                this.shortName(instance.shortName());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder shortName(String shortName) {
            this.shortName = Objects.requireNonNull(shortName, "shortName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputStickerSetShortName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputStickerSetShortName(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("shortName");
            }
            return "Cannot build InputStickerSetShortName, some of required attributes are not set " + attributes;
        }
    }
}

