/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.InputStickerSetThumb;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStickerSetThumb
implements InputStickerSetThumb {
    private final int identifier;
    private final InputStickerSet stickerset;
    private final int thumbVersion;

    private ImmutableInputStickerSetThumb(InputStickerSet stickerset, int thumbVersion) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.thumbVersion = thumbVersion;
        this.identifier = InputStickerSetThumb.super.identifier();
    }

    private ImmutableInputStickerSetThumb(Builder builder) {
        this.stickerset = builder.stickerset;
        this.thumbVersion = builder.thumbVersion;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStickerSetThumb.super.identifier();
    }

    private ImmutableInputStickerSetThumb(int identifier, InputStickerSet stickerset, int thumbVersion) {
        this.identifier = identifier;
        this.stickerset = stickerset;
        this.thumbVersion = thumbVersion;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    public int thumbVersion() {
        return this.thumbVersion;
    }

    public final ImmutableInputStickerSetThumb withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputStickerSetThumb(value, this.stickerset, this.thumbVersion);
    }

    public final ImmutableInputStickerSetThumb withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableInputStickerSetThumb(this.identifier, newValue, this.thumbVersion);
    }

    public final ImmutableInputStickerSetThumb withThumbVersion(int value) {
        if (this.thumbVersion == value) {
            return this;
        }
        return new ImmutableInputStickerSetThumb(this.identifier, this.stickerset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStickerSetThumb && this.equalTo(0, (ImmutableInputStickerSetThumb)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStickerSetThumb another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset) && this.thumbVersion == another.thumbVersion;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        h += (h << 5) + this.thumbVersion;
        return h;
    }

    public String toString() {
        return "InputStickerSetThumb{identifier=" + this.identifier + ", stickerset=" + this.stickerset + ", thumbVersion=" + this.thumbVersion + "}";
    }

    public static ImmutableInputStickerSetThumb of(InputStickerSet stickerset, int thumbVersion) {
        return new ImmutableInputStickerSetThumb(stickerset, thumbVersion);
    }

    public static ImmutableInputStickerSetThumb copyOf(InputStickerSetThumb instance) {
        if (instance instanceof ImmutableInputStickerSetThumb) {
            return (ImmutableInputStickerSetThumb)instance;
        }
        return ImmutableInputStickerSetThumb.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long INIT_BIT_THUMB_VERSION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputStickerSet stickerset;
        private int thumbVersion;

        private Builder() {
        }

        public final Builder from(InputStickerSetThumb instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputStickerSetThumb) {
                instance = (InputStickerSetThumb)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
                this.thumbVersion(instance.thumbVersion());
            }
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder thumbVersion(int thumbVersion) {
            this.thumbVersion = thumbVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInputStickerSetThumb build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputStickerSetThumb(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("thumbVersion");
            }
            return "Cannot build InputStickerSetThumb, some of required attributes are not set " + attributes;
        }
    }
}

