/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.InputStickerSetThumbLegacy;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStickerSetThumbLegacy
implements InputStickerSetThumbLegacy {
    private final int identifier;
    private final InputStickerSet stickerset;
    private final long volumeId;
    private final int localId;

    private ImmutableInputStickerSetThumbLegacy(InputStickerSet stickerset, long volumeId, int localId) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.volumeId = volumeId;
        this.localId = localId;
        this.identifier = InputStickerSetThumbLegacy.super.identifier();
    }

    private ImmutableInputStickerSetThumbLegacy(Builder builder) {
        this.stickerset = builder.stickerset;
        this.volumeId = builder.volumeId;
        this.localId = builder.localId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStickerSetThumbLegacy.super.identifier();
    }

    private ImmutableInputStickerSetThumbLegacy(int identifier, InputStickerSet stickerset, long volumeId, int localId) {
        this.identifier = identifier;
        this.stickerset = stickerset;
        this.volumeId = volumeId;
        this.localId = localId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    public long volumeId() {
        return this.volumeId;
    }

    @Override
    public int localId() {
        return this.localId;
    }

    public final ImmutableInputStickerSetThumbLegacy withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputStickerSetThumbLegacy(value, this.stickerset, this.volumeId, this.localId);
    }

    public final ImmutableInputStickerSetThumbLegacy withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableInputStickerSetThumbLegacy(this.identifier, newValue, this.volumeId, this.localId);
    }

    public final ImmutableInputStickerSetThumbLegacy withVolumeId(long value) {
        if (this.volumeId == value) {
            return this;
        }
        return new ImmutableInputStickerSetThumbLegacy(this.identifier, this.stickerset, value, this.localId);
    }

    public final ImmutableInputStickerSetThumbLegacy withLocalId(int value) {
        if (this.localId == value) {
            return this;
        }
        return new ImmutableInputStickerSetThumbLegacy(this.identifier, this.stickerset, this.volumeId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStickerSetThumbLegacy && this.equalTo(0, (ImmutableInputStickerSetThumbLegacy)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStickerSetThumbLegacy another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset) && this.volumeId == another.volumeId && this.localId == another.localId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        h += (h << 5) + Long.hashCode(this.volumeId);
        h += (h << 5) + this.localId;
        return h;
    }

    public String toString() {
        return "InputStickerSetThumbLegacy{identifier=" + this.identifier + ", stickerset=" + this.stickerset + ", volumeId=" + this.volumeId + ", localId=" + this.localId + "}";
    }

    public static ImmutableInputStickerSetThumbLegacy of(InputStickerSet stickerset, long volumeId, int localId) {
        return new ImmutableInputStickerSetThumbLegacy(stickerset, volumeId, localId);
    }

    public static ImmutableInputStickerSetThumbLegacy copyOf(InputStickerSetThumbLegacy instance) {
        if (instance instanceof ImmutableInputStickerSetThumbLegacy) {
            return (ImmutableInputStickerSetThumbLegacy)instance;
        }
        return ImmutableInputStickerSetThumbLegacy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long INIT_BIT_VOLUME_ID = 2L;
        private static final long INIT_BIT_LOCAL_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputStickerSet stickerset;
        private long volumeId;
        private int localId;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStickerSetThumbLegacy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStickerSetThumbLegacy) {
                instance = (InputStickerSetThumbLegacy)object;
                this.volumeId(instance.volumeId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
                this.localId(instance.localId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder volumeId(long volumeId) {
            this.volumeId = volumeId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder localId(int localId) {
            this.localId = localId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputStickerSetThumbLegacy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputStickerSetThumbLegacy(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("volumeId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("localId");
            }
            return "Cannot build InputStickerSetThumbLegacy, some of required attributes are not set " + attributes;
        }
    }
}

