/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputStickeredMedia;
import telegram4j.tl.InputStickeredMediaDocument;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStickeredMediaDocument
implements InputStickeredMediaDocument {
    private final int identifier;
    private final InputDocument id;

    private ImmutableInputStickeredMediaDocument(InputDocument id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = InputStickeredMediaDocument.super.identifier();
    }

    private ImmutableInputStickeredMediaDocument(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStickeredMediaDocument.super.identifier();
    }

    private ImmutableInputStickeredMediaDocument(int identifier, InputDocument id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputDocument id() {
        return this.id;
    }

    public final ImmutableInputStickeredMediaDocument withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputStickeredMediaDocument(value, this.id);
    }

    public final ImmutableInputStickeredMediaDocument withId(InputDocument value) {
        if (this.id == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "id");
        return new ImmutableInputStickeredMediaDocument(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStickeredMediaDocument && this.equalTo(0, (ImmutableInputStickeredMediaDocument)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStickeredMediaDocument another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "InputStickeredMediaDocument{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableInputStickeredMediaDocument of(InputDocument id) {
        return new ImmutableInputStickeredMediaDocument(id);
    }

    public static ImmutableInputStickeredMediaDocument copyOf(InputStickeredMediaDocument instance) {
        if (instance instanceof ImmutableInputStickeredMediaDocument) {
            return (ImmutableInputStickeredMediaDocument)instance;
        }
        return ImmutableInputStickeredMediaDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputDocument id;

        private Builder() {
        }

        public final Builder from(InputStickeredMediaDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStickeredMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputStickeredMedia instance;
            long bits = 0L;
            if (object instanceof InputStickeredMediaDocument) {
                instance = (InputStickeredMediaDocument)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStickeredMedia) {
                instance = (InputStickeredMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputDocument id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputStickeredMediaDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputStickeredMediaDocument(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build InputStickeredMediaDocument, some of required attributes are not set " + attributes;
        }
    }
}

