/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPhoto;
import telegram4j.tl.InputStickeredMedia;
import telegram4j.tl.InputStickeredMediaPhoto;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStickeredMediaPhoto
implements InputStickeredMediaPhoto {
    private final int identifier;
    private final InputPhoto id;

    private ImmutableInputStickeredMediaPhoto(InputPhoto id) {
        this.id = Objects.requireNonNull(id, "id");
        this.identifier = InputStickeredMediaPhoto.super.identifier();
    }

    private ImmutableInputStickeredMediaPhoto(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStickeredMediaPhoto.super.identifier();
    }

    private ImmutableInputStickeredMediaPhoto(int identifier, InputPhoto id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPhoto id() {
        return this.id;
    }

    public final ImmutableInputStickeredMediaPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputStickeredMediaPhoto(value, this.id);
    }

    public final ImmutableInputStickeredMediaPhoto withId(InputPhoto value) {
        if (this.id == value) {
            return this;
        }
        InputPhoto newValue = Objects.requireNonNull(value, "id");
        return new ImmutableInputStickeredMediaPhoto(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStickeredMediaPhoto && this.equalTo(0, (ImmutableInputStickeredMediaPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStickeredMediaPhoto another) {
        return this.identifier == another.identifier && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "InputStickeredMediaPhoto{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableInputStickeredMediaPhoto of(InputPhoto id) {
        return new ImmutableInputStickeredMediaPhoto(id);
    }

    public static ImmutableInputStickeredMediaPhoto copyOf(InputStickeredMediaPhoto instance) {
        if (instance instanceof ImmutableInputStickeredMediaPhoto) {
            return (ImmutableInputStickeredMediaPhoto)instance;
        }
        return ImmutableInputStickeredMediaPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPhoto id;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStickeredMediaPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStickeredMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStickeredMediaPhoto) {
                instance = (InputStickeredMediaPhoto)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof InputStickeredMedia) {
                instance = (InputStickeredMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputPhoto id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputStickeredMediaPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputStickeredMediaPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build InputStickeredMediaPhoto, some of required attributes are not set " + attributes;
        }
    }
}

