/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStorePaymentGiftPremium;
import telegram4j.tl.InputStorePaymentPurpose;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStorePaymentGiftPremium
implements InputStorePaymentGiftPremium {
    private final int identifier;
    private final InputUser userId;
    private final String currency;
    private final long amount;

    private ImmutableInputStorePaymentGiftPremium(InputUser userId, String currency, long amount) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.currency = Objects.requireNonNull(currency, "currency");
        this.amount = amount;
        this.identifier = InputStorePaymentGiftPremium.super.identifier();
    }

    private ImmutableInputStorePaymentGiftPremium(Builder builder) {
        this.userId = builder.userId;
        this.currency = builder.currency;
        this.amount = builder.amount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputStorePaymentGiftPremium.super.identifier();
    }

    private ImmutableInputStorePaymentGiftPremium(int identifier, InputUser userId, String currency, long amount) {
        this.identifier = identifier;
        this.userId = userId;
        this.currency = currency;
        this.amount = amount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long amount() {
        return this.amount;
    }

    public final ImmutableInputStorePaymentGiftPremium withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputStorePaymentGiftPremium(value, this.userId, this.currency, this.amount);
    }

    public final ImmutableInputStorePaymentGiftPremium withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableInputStorePaymentGiftPremium(this.identifier, newValue, this.currency, this.amount);
    }

    public final ImmutableInputStorePaymentGiftPremium withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableInputStorePaymentGiftPremium(this.identifier, this.userId, newValue, this.amount);
    }

    public final ImmutableInputStorePaymentGiftPremium withAmount(long value) {
        if (this.amount == value) {
            return this;
        }
        return new ImmutableInputStorePaymentGiftPremium(this.identifier, this.userId, this.currency, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStorePaymentGiftPremium && this.equalTo(0, (ImmutableInputStorePaymentGiftPremium)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStorePaymentGiftPremium another) {
        return this.identifier == another.identifier && this.userId.equals(another.userId) && this.currency.equals(another.currency) && this.amount == another.amount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.amount);
        return h;
    }

    public String toString() {
        return "InputStorePaymentGiftPremium{identifier=" + this.identifier + ", userId=" + this.userId + ", currency=" + this.currency + ", amount=" + this.amount + "}";
    }

    public static ImmutableInputStorePaymentGiftPremium of(InputUser userId, String currency, long amount) {
        return new ImmutableInputStorePaymentGiftPremium(userId, currency, amount);
    }

    public static ImmutableInputStorePaymentGiftPremium copyOf(InputStorePaymentGiftPremium instance) {
        if (instance instanceof ImmutableInputStorePaymentGiftPremium) {
            return (ImmutableInputStorePaymentGiftPremium)instance;
        }
        return ImmutableInputStorePaymentGiftPremium.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_CURRENCY = 2L;
        private static final long INIT_BIT_AMOUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputUser userId;
        private String currency;
        private long amount;

        private Builder() {
        }

        public final Builder from(InputStorePaymentGiftPremium instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStorePaymentPurpose instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputStorePaymentPurpose instance;
            long bits = 0L;
            if (object instanceof InputStorePaymentGiftPremium) {
                instance = (InputStorePaymentGiftPremium)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.amount(instance.amount());
                this.currency(instance.currency());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStorePaymentPurpose) {
                instance = (InputStorePaymentPurpose)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder amount(long amount) {
            this.amount = amount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInputStorePaymentGiftPremium build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputStorePaymentGiftPremium(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount");
            }
            return "Cannot build InputStorePaymentGiftPremium, some of required attributes are not set " + attributes;
        }
    }
}

