/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputStorePaymentPremiumSubscription;
import telegram4j.tl.InputStorePaymentPurpose;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputStorePaymentPremiumSubscription
implements InputStorePaymentPremiumSubscription {
    private final int identifier;
    private final int flags;
    private final boolean restore;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableInputStorePaymentPremiumSubscription INSTANCE = ImmutableInputStorePaymentPremiumSubscription.validate(new ImmutableInputStorePaymentPremiumSubscription());

    private ImmutableInputStorePaymentPremiumSubscription() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.restore = this.initShim.restore();
        this.initShim = null;
    }

    private ImmutableInputStorePaymentPremiumSubscription(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.restoreIsSet()) {
            this.initShim.restore(builder.restore);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.restore = this.initShim.restore();
        this.initShim = null;
    }

    private ImmutableInputStorePaymentPremiumSubscription(int identifier, int flags, boolean restore) {
        this.identifier = identifier;
        this.flags = flags;
        this.restore = restore;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InputStorePaymentPremiumSubscription.super.identifier();
    }

    private int flagsInitialize() {
        return InputStorePaymentPremiumSubscription.super.flags();
    }

    private boolean restoreInitialize() {
        return InputStorePaymentPremiumSubscription.super.restore();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean restore() {
        InitShim shim = this.initShim;
        return shim != null ? shim.restore() : this.restore;
    }

    public final ImmutableInputStorePaymentPremiumSubscription withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputStorePaymentPremiumSubscription.validate(new ImmutableInputStorePaymentPremiumSubscription(value, this.flags, this.restore));
    }

    public final ImmutableInputStorePaymentPremiumSubscription withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableInputStorePaymentPremiumSubscription.validate(new ImmutableInputStorePaymentPremiumSubscription(this.identifier, value, this.restore));
    }

    public final ImmutableInputStorePaymentPremiumSubscription withRestore(boolean value) {
        if (this.restore == value) {
            return this;
        }
        return ImmutableInputStorePaymentPremiumSubscription.validate(new ImmutableInputStorePaymentPremiumSubscription(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputStorePaymentPremiumSubscription && this.equalTo(0, (ImmutableInputStorePaymentPremiumSubscription)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputStorePaymentPremiumSubscription another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.restore == another.restore;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.restore);
        return h;
    }

    public String toString() {
        return "InputStorePaymentPremiumSubscription{identifier=" + this.identifier + ", flags=" + this.flags + ", restore=" + this.restore + "}";
    }

    public static ImmutableInputStorePaymentPremiumSubscription of() {
        return INSTANCE;
    }

    private static ImmutableInputStorePaymentPremiumSubscription validate(ImmutableInputStorePaymentPremiumSubscription instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputStorePaymentPremiumSubscription copyOf(InputStorePaymentPremiumSubscription instance) {
        if (instance instanceof ImmutableInputStorePaymentPremiumSubscription) {
            return (ImmutableInputStorePaymentPremiumSubscription)instance;
        }
        return ImmutableInputStorePaymentPremiumSubscription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_RESTORE = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean restore;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStorePaymentPurpose instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputStorePaymentPremiumSubscription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStorePaymentPurpose) {
                instance = (InputStorePaymentPurpose)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputStorePaymentPremiumSubscription) {
                instance = (InputStorePaymentPremiumSubscription)object;
                this.restore(instance.restore());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder restore(boolean restore) {
            this.restore = restore;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableInputStorePaymentPremiumSubscription build() {
            return ImmutableInputStorePaymentPremiumSubscription.validate(new ImmutableInputStorePaymentPremiumSubscription(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean restoreIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte restoreBuildStage = 0;
        private boolean restore;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInputStorePaymentPremiumSubscription.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInputStorePaymentPremiumSubscription.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean restore() {
            if (this.restoreBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.restoreBuildStage == 0) {
                this.restoreBuildStage = (byte)-1;
                this.restore = ImmutableInputStorePaymentPremiumSubscription.this.restoreInitialize();
                this.restoreBuildStage = 1;
            }
            return this.restore;
        }

        void restore(boolean restore) {
            this.restore = restore;
            this.restoreBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.restoreBuildStage == -1) {
                attributes.add("restore");
            }
            return "Cannot build InputStorePaymentPremiumSubscription, attribute initializers form cycle " + attributes;
        }
    }
}

