/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.InputTakeoutFileLocation;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputTakeoutFileLocation
implements InputTakeoutFileLocation {
    private final int identifier;
    private static final ImmutableInputTakeoutFileLocation INSTANCE = ImmutableInputTakeoutFileLocation.validate(new ImmutableInputTakeoutFileLocation());

    private ImmutableInputTakeoutFileLocation() {
        this.identifier = InputTakeoutFileLocation.super.identifier();
    }

    private ImmutableInputTakeoutFileLocation(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputTakeoutFileLocation.super.identifier();
    }

    private ImmutableInputTakeoutFileLocation(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputTakeoutFileLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputTakeoutFileLocation.validate(new ImmutableInputTakeoutFileLocation(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputTakeoutFileLocation && this.equalTo(0, (ImmutableInputTakeoutFileLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputTakeoutFileLocation another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputTakeoutFileLocation{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputTakeoutFileLocation of() {
        return INSTANCE;
    }

    private static ImmutableInputTakeoutFileLocation validate(ImmutableInputTakeoutFileLocation instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputTakeoutFileLocation copyOf(InputTakeoutFileLocation instance) {
        if (instance instanceof ImmutableInputTakeoutFileLocation) {
            return (ImmutableInputTakeoutFileLocation)instance;
        }
        return ImmutableInputTakeoutFileLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputTakeoutFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputTakeoutFileLocation) {
                instance = (InputTakeoutFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputTakeoutFileLocation build() {
            return ImmutableInputTakeoutFileLocation.validate(new ImmutableInputTakeoutFileLocation(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

