/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputTheme;
import telegram4j.tl.InputThemeSlug;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputThemeSlug
implements InputThemeSlug {
    private final int identifier;
    private final String slug;

    private ImmutableInputThemeSlug(String slug) {
        this.slug = Objects.requireNonNull(slug, "slug");
        this.identifier = InputThemeSlug.super.identifier();
    }

    private ImmutableInputThemeSlug(Builder builder) {
        this.slug = builder.slug;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputThemeSlug.super.identifier();
    }

    private ImmutableInputThemeSlug(int identifier, String slug) {
        this.identifier = identifier;
        this.slug = slug;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    public final ImmutableInputThemeSlug withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputThemeSlug(value, this.slug);
    }

    public final ImmutableInputThemeSlug withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (this.slug.equals(newValue)) {
            return this;
        }
        return new ImmutableInputThemeSlug(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputThemeSlug && this.equalTo(0, (ImmutableInputThemeSlug)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputThemeSlug another) {
        return this.identifier == another.identifier && this.slug.equals(another.slug);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.slug.hashCode();
        return h;
    }

    public String toString() {
        return "InputThemeSlug{identifier=" + this.identifier + ", slug=" + this.slug + "}";
    }

    public static ImmutableInputThemeSlug of(String slug) {
        return new ImmutableInputThemeSlug(slug);
    }

    public static ImmutableInputThemeSlug copyOf(InputThemeSlug instance) {
        if (instance instanceof ImmutableInputThemeSlug) {
            return (ImmutableInputThemeSlug)instance;
        }
        return ImmutableInputThemeSlug.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SLUG = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String slug;

        private Builder() {
        }

        public final Builder from(InputThemeSlug instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputTheme instance;
            long bits = 0L;
            if (object instanceof InputThemeSlug) {
                instance = (InputThemeSlug)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.slug(instance.slug());
            }
            if (object instanceof InputTheme) {
                instance = (InputTheme)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputThemeSlug build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputThemeSlug(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("slug");
            }
            return "Cannot build InputThemeSlug, some of required attributes are not set " + attributes;
        }
    }
}

