/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.InputUser;
import telegram4j.tl.InputUserSelf;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputUserSelf
implements InputUserSelf {
    private final int identifier;
    private static final ImmutableInputUserSelf INSTANCE = ImmutableInputUserSelf.validate(new ImmutableInputUserSelf());

    private ImmutableInputUserSelf() {
        this.identifier = InputUserSelf.super.identifier();
    }

    private ImmutableInputUserSelf(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputUserSelf.super.identifier();
    }

    private ImmutableInputUserSelf(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableInputUserSelf withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInputUserSelf.validate(new ImmutableInputUserSelf(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputUserSelf && this.equalTo(0, (ImmutableInputUserSelf)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputUserSelf another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "InputUserSelf{identifier=" + this.identifier + "}";
    }

    public static ImmutableInputUserSelf of() {
        return INSTANCE;
    }

    private static ImmutableInputUserSelf validate(ImmutableInputUserSelf instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInputUserSelf copyOf(InputUserSelf instance) {
        if (instance instanceof ImmutableInputUserSelf) {
            return (ImmutableInputUserSelf)instance;
        }
        return ImmutableInputUserSelf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputUserSelf instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputUserSelf) {
                instance = (InputUserSelf)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputUser) {
                instance = (InputUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInputUserSelf build() {
            return ImmutableInputUserSelf.validate(new ImmutableInputUserSelf(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

