/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputWallPaper;
import telegram4j.tl.InputWallPaperSlug;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputWallPaperSlug
implements InputWallPaperSlug {
    private final int identifier;
    private final String slug;

    private ImmutableInputWallPaperSlug(String slug) {
        this.slug = Objects.requireNonNull(slug, "slug");
        this.identifier = InputWallPaperSlug.super.identifier();
    }

    private ImmutableInputWallPaperSlug(Builder builder) {
        this.slug = builder.slug;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputWallPaperSlug.super.identifier();
    }

    private ImmutableInputWallPaperSlug(int identifier, String slug) {
        this.identifier = identifier;
        this.slug = slug;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    public final ImmutableInputWallPaperSlug withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputWallPaperSlug(value, this.slug);
    }

    public final ImmutableInputWallPaperSlug withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (this.slug.equals(newValue)) {
            return this;
        }
        return new ImmutableInputWallPaperSlug(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputWallPaperSlug && this.equalTo(0, (ImmutableInputWallPaperSlug)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputWallPaperSlug another) {
        return this.identifier == another.identifier && this.slug.equals(another.slug);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.slug.hashCode();
        return h;
    }

    public String toString() {
        return "InputWallPaperSlug{identifier=" + this.identifier + ", slug=" + this.slug + "}";
    }

    public static ImmutableInputWallPaperSlug of(String slug) {
        return new ImmutableInputWallPaperSlug(slug);
    }

    public static ImmutableInputWallPaperSlug copyOf(InputWallPaperSlug instance) {
        if (instance instanceof ImmutableInputWallPaperSlug) {
            return (ImmutableInputWallPaperSlug)instance;
        }
        return ImmutableInputWallPaperSlug.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SLUG = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String slug;

        private Builder() {
        }

        public final Builder from(InputWallPaperSlug instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputWallPaper instance;
            long bits = 0L;
            if (object instanceof InputWallPaperSlug) {
                instance = (InputWallPaperSlug)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.slug(instance.slug());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputWallPaper) {
                instance = (InputWallPaper)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInputWallPaperSlug build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputWallPaperSlug(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("slug");
            }
            return "Cannot build InputWallPaperSlug, some of required attributes are not set " + attributes;
        }
    }
}

