/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.InputWebDocument;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputWebDocument
implements InputWebDocument {
    private final int identifier;
    private final String url;
    private final int size;
    private final String mimeType;
    private final List<DocumentAttribute> attributes;

    private ImmutableInputWebDocument(String url, int size, String mimeType) {
        this.url = Objects.requireNonNull(url, "url");
        this.size = size;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.attributes = Collections.emptyList();
        this.identifier = InputWebDocument.super.identifier();
    }

    private ImmutableInputWebDocument(Builder builder) {
        this.url = builder.url;
        this.size = builder.size;
        this.mimeType = builder.mimeType;
        this.attributes = ImmutableInputWebDocument.createUnmodifiableList(true, builder.attributes);
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputWebDocument.super.identifier();
    }

    private ImmutableInputWebDocument(int identifier, String url, int size, String mimeType, List<DocumentAttribute> attributes) {
        this.identifier = identifier;
        this.url = url;
        this.size = size;
        this.mimeType = mimeType;
        this.attributes = attributes;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public List<DocumentAttribute> attributes() {
        return this.attributes;
    }

    public final ImmutableInputWebDocument withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputWebDocument(value, this.url, this.size, this.mimeType, this.attributes);
    }

    public final ImmutableInputWebDocument withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableInputWebDocument(this.identifier, newValue, this.size, this.mimeType, this.attributes);
    }

    public final ImmutableInputWebDocument withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableInputWebDocument(this.identifier, this.url, value, this.mimeType, this.attributes);
    }

    public final ImmutableInputWebDocument withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableInputWebDocument(this.identifier, this.url, this.size, newValue, this.attributes);
    }

    public final ImmutableInputWebDocument withAttributes(DocumentAttribute ... elements) {
        List<DocumentAttribute> newValue = ImmutableInputWebDocument.createUnmodifiableList(false, ImmutableInputWebDocument.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInputWebDocument(this.identifier, this.url, this.size, this.mimeType, newValue);
    }

    public final ImmutableInputWebDocument withAttributes(Iterable<? extends DocumentAttribute> elements) {
        if (this.attributes == elements) {
            return this;
        }
        List<DocumentAttribute> newValue = ImmutableInputWebDocument.createUnmodifiableList(false, ImmutableInputWebDocument.createSafeList(elements, true, false));
        return new ImmutableInputWebDocument(this.identifier, this.url, this.size, this.mimeType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputWebDocument && this.equalTo(0, (ImmutableInputWebDocument)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputWebDocument another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.size == another.size && this.mimeType.equals(another.mimeType) && this.attributes.equals(another.attributes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.size;
        h += (h << 5) + this.mimeType.hashCode();
        h += (h << 5) + this.attributes.hashCode();
        return h;
    }

    public String toString() {
        return "InputWebDocument{identifier=" + this.identifier + ", url=" + this.url + ", size=" + this.size + ", mimeType=" + this.mimeType + ", attributes=" + this.attributes + "}";
    }

    public static ImmutableInputWebDocument of(String url, int size, String mimeType) {
        return new ImmutableInputWebDocument(url, size, mimeType);
    }

    public static ImmutableInputWebDocument copyOf(InputWebDocument instance) {
        if (instance instanceof ImmutableInputWebDocument) {
            return (ImmutableInputWebDocument)instance;
        }
        return ImmutableInputWebDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_SIZE = 2L;
        private static final long INIT_BIT_MIME_TYPE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String url;
        private int size;
        private String mimeType;
        private List<DocumentAttribute> attributes = new ArrayList<DocumentAttribute>();

        private Builder() {
        }

        public final Builder from(InputWebDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputWebDocument instance;
            long bits = 0L;
            if (object instanceof InputWebDocument) {
                instance = (InputWebDocument)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllAttributes(instance.attributes());
                this.mimeType(instance.mimeType());
                this.size(instance.size());
                this.url(instance.url());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addAttribute(DocumentAttribute element) {
            this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            return this;
        }

        public final Builder addAttributes(DocumentAttribute ... elements) {
            for (DocumentAttribute element : elements) {
                this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        public final Builder attributes(Iterable<? extends DocumentAttribute> elements) {
            this.attributes.clear();
            return this.addAllAttributes(elements);
        }

        public final Builder addAllAttributes(Iterable<? extends DocumentAttribute> elements) {
            for (DocumentAttribute documentAttribute : elements) {
                this.attributes.add(Objects.requireNonNull(documentAttribute, "attributes element"));
            }
            return this;
        }

        public ImmutableInputWebDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputWebDocument(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mimeType");
            }
            return "Cannot build InputWebDocument, some of required attributes are not set " + attributes;
        }
    }
}

