/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.InputWebFileGeoPointLocation;
import telegram4j.tl.InputWebFileLocation;
import telegram4j.tl.api.TlObject;

public final class ImmutableInputWebFileGeoPointLocation
implements InputWebFileGeoPointLocation {
    private final int identifier;
    private final InputGeoPoint geoPoint;
    private final long accessHash;
    private final int w;
    private final int h;
    private final int zoom;
    private final int scale;

    private ImmutableInputWebFileGeoPointLocation(InputGeoPoint geoPoint, long accessHash, int w, int h, int zoom, int scale) {
        this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
        this.accessHash = accessHash;
        this.w = w;
        this.h = h;
        this.zoom = zoom;
        this.scale = scale;
        this.identifier = InputWebFileGeoPointLocation.super.identifier();
    }

    private ImmutableInputWebFileGeoPointLocation(Builder builder) {
        this.geoPoint = builder.geoPoint;
        this.accessHash = builder.accessHash;
        this.w = builder.w;
        this.h = builder.h;
        this.zoom = builder.zoom;
        this.scale = builder.scale;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InputWebFileGeoPointLocation.super.identifier();
    }

    private ImmutableInputWebFileGeoPointLocation(int identifier, InputGeoPoint geoPoint, long accessHash, int w, int h, int zoom, int scale) {
        this.identifier = identifier;
        this.geoPoint = geoPoint;
        this.accessHash = accessHash;
        this.w = w;
        this.h = h;
        this.zoom = zoom;
        this.scale = scale;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGeoPoint geoPoint() {
        return this.geoPoint;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public int zoom() {
        return this.zoom;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    public final ImmutableInputWebFileGeoPointLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInputWebFileGeoPointLocation(value, this.geoPoint, this.accessHash, this.w, this.h, this.zoom, this.scale);
    }

    public final ImmutableInputWebFileGeoPointLocation withGeoPoint(InputGeoPoint value) {
        if (this.geoPoint == value) {
            return this;
        }
        InputGeoPoint newValue = Objects.requireNonNull(value, "geoPoint");
        return new ImmutableInputWebFileGeoPointLocation(this.identifier, newValue, this.accessHash, this.w, this.h, this.zoom, this.scale);
    }

    public final ImmutableInputWebFileGeoPointLocation withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableInputWebFileGeoPointLocation(this.identifier, this.geoPoint, value, this.w, this.h, this.zoom, this.scale);
    }

    public final ImmutableInputWebFileGeoPointLocation withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutableInputWebFileGeoPointLocation(this.identifier, this.geoPoint, this.accessHash, value, this.h, this.zoom, this.scale);
    }

    public final ImmutableInputWebFileGeoPointLocation withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutableInputWebFileGeoPointLocation(this.identifier, this.geoPoint, this.accessHash, this.w, value, this.zoom, this.scale);
    }

    public final ImmutableInputWebFileGeoPointLocation withZoom(int value) {
        if (this.zoom == value) {
            return this;
        }
        return new ImmutableInputWebFileGeoPointLocation(this.identifier, this.geoPoint, this.accessHash, this.w, this.h, value, this.scale);
    }

    public final ImmutableInputWebFileGeoPointLocation withScale(int value) {
        if (this.scale == value) {
            return this;
        }
        return new ImmutableInputWebFileGeoPointLocation(this.identifier, this.geoPoint, this.accessHash, this.w, this.h, this.zoom, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputWebFileGeoPointLocation && this.equalTo(0, (ImmutableInputWebFileGeoPointLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableInputWebFileGeoPointLocation another) {
        return this.identifier == another.identifier && this.geoPoint.equals(another.geoPoint) && this.accessHash == another.accessHash && this.w == another.w && this.h == another.h && this.zoom == another.zoom && this.scale == another.scale;
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.geoPoint.hashCode();
        h$$ += (h$$ << 5) + Long.hashCode(this.accessHash);
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        h$$ += (h$$ << 5) + this.zoom;
        h$$ += (h$$ << 5) + this.scale;
        return h$$;
    }

    public String toString() {
        return "InputWebFileGeoPointLocation{identifier=" + this.identifier + ", geoPoint=" + this.geoPoint + ", accessHash=" + this.accessHash + ", w=" + this.w + ", h=" + this.h + ", zoom=" + this.zoom + ", scale=" + this.scale + "}";
    }

    public static ImmutableInputWebFileGeoPointLocation of(InputGeoPoint geoPoint, long accessHash, int w, int h, int zoom, int scale) {
        return new ImmutableInputWebFileGeoPointLocation(geoPoint, accessHash, w, h, zoom, scale);
    }

    public static ImmutableInputWebFileGeoPointLocation copyOf(InputWebFileGeoPointLocation instance) {
        if (instance instanceof ImmutableInputWebFileGeoPointLocation) {
            return (ImmutableInputWebFileGeoPointLocation)instance;
        }
        return ImmutableInputWebFileGeoPointLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO_POINT = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_W = 4L;
        private static final long INIT_BIT_H = 8L;
        private static final long INIT_BIT_ZOOM = 16L;
        private static final long INIT_BIT_SCALE = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private InputGeoPoint geoPoint;
        private long accessHash;
        private int w;
        private int h;
        private int zoom;
        private int scale;

        private Builder() {
        }

        public final Builder from(InputWebFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputWebFileGeoPointLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputWebFileLocation instance;
            long bits = 0L;
            if (object instanceof InputWebFileLocation) {
                instance = (InputWebFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputWebFileGeoPointLocation) {
                instance = (InputWebFileGeoPointLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.w(instance.w());
                this.h(instance.h());
                this.scale(instance.scale());
                this.accessHash(instance.accessHash());
                this.zoom(instance.zoom());
                this.geoPoint(instance.geoPoint());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder geoPoint(InputGeoPoint geoPoint) {
            this.geoPoint = Objects.requireNonNull(geoPoint, "geoPoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder zoom(int zoom) {
            this.zoom = zoom;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder scale(int scale) {
            this.scale = scale;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableInputWebFileGeoPointLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInputWebFileGeoPointLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geoPoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("h");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("zoom");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("scale");
            }
            return "Cannot build InputWebFileGeoPointLocation, some of required attributes are not set " + attributes;
        }
    }
}

