/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Invoice;
import telegram4j.tl.LabeledPrice;
import telegram4j.tl.api.TlObject;

public final class ImmutableInvoice
implements Invoice {
    private final int identifier;
    private final int flags;
    private final boolean test;
    private final boolean nameRequested;
    private final boolean phoneRequested;
    private final boolean emailRequested;
    private final boolean shippingAddressRequested;
    private final boolean flexible;
    private final boolean phoneToProvider;
    private final boolean emailToProvider;
    private final boolean recurring;
    private final String currency;
    private final List<LabeledPrice> prices;
    @Nullable
    private final Long maxTipAmount;
    @Nullable
    private final List<Long> suggestedTipAmounts;
    @Nullable
    private final String recurringTermsUrl;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInvoice(String currency) {
        this.currency = Objects.requireNonNull(currency, "currency");
        this.prices = Collections.emptyList();
        this.maxTipAmount = null;
        this.suggestedTipAmounts = null;
        this.recurringTermsUrl = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.test = this.initShim.test();
        this.nameRequested = this.initShim.nameRequested();
        this.phoneRequested = this.initShim.phoneRequested();
        this.emailRequested = this.initShim.emailRequested();
        this.shippingAddressRequested = this.initShim.shippingAddressRequested();
        this.flexible = this.initShim.flexible();
        this.phoneToProvider = this.initShim.phoneToProvider();
        this.emailToProvider = this.initShim.emailToProvider();
        this.recurring = this.initShim.recurring();
        this.initShim = null;
    }

    private ImmutableInvoice(Builder builder) {
        this.currency = builder.currency;
        this.prices = ImmutableInvoice.createUnmodifiableList(true, builder.prices);
        this.maxTipAmount = builder.maxTipAmount;
        this.suggestedTipAmounts = builder.suggestedTipAmounts == null ? null : ImmutableInvoice.createUnmodifiableList(true, builder.suggestedTipAmounts);
        this.recurringTermsUrl = builder.recurringTermsUrl;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.testIsSet()) {
            this.initShim.test(builder.test);
        }
        if (builder.nameRequestedIsSet()) {
            this.initShim.nameRequested(builder.nameRequested);
        }
        if (builder.phoneRequestedIsSet()) {
            this.initShim.phoneRequested(builder.phoneRequested);
        }
        if (builder.emailRequestedIsSet()) {
            this.initShim.emailRequested(builder.emailRequested);
        }
        if (builder.shippingAddressRequestedIsSet()) {
            this.initShim.shippingAddressRequested(builder.shippingAddressRequested);
        }
        if (builder.flexibleIsSet()) {
            this.initShim.flexible(builder.flexible);
        }
        if (builder.phoneToProviderIsSet()) {
            this.initShim.phoneToProvider(builder.phoneToProvider);
        }
        if (builder.emailToProviderIsSet()) {
            this.initShim.emailToProvider(builder.emailToProvider);
        }
        if (builder.recurringIsSet()) {
            this.initShim.recurring(builder.recurring);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.test = this.initShim.test();
        this.nameRequested = this.initShim.nameRequested();
        this.phoneRequested = this.initShim.phoneRequested();
        this.emailRequested = this.initShim.emailRequested();
        this.shippingAddressRequested = this.initShim.shippingAddressRequested();
        this.flexible = this.initShim.flexible();
        this.phoneToProvider = this.initShim.phoneToProvider();
        this.emailToProvider = this.initShim.emailToProvider();
        this.recurring = this.initShim.recurring();
        this.initShim = null;
    }

    private ImmutableInvoice(int identifier, int flags, boolean test, boolean nameRequested, boolean phoneRequested, boolean emailRequested, boolean shippingAddressRequested, boolean flexible, boolean phoneToProvider, boolean emailToProvider, boolean recurring, String currency, List<LabeledPrice> prices, @Nullable Long maxTipAmount, @Nullable List<Long> suggestedTipAmounts, @Nullable String recurringTermsUrl) {
        this.identifier = identifier;
        this.flags = flags;
        this.test = test;
        this.nameRequested = nameRequested;
        this.phoneRequested = phoneRequested;
        this.emailRequested = emailRequested;
        this.shippingAddressRequested = shippingAddressRequested;
        this.flexible = flexible;
        this.phoneToProvider = phoneToProvider;
        this.emailToProvider = emailToProvider;
        this.recurring = recurring;
        this.currency = currency;
        this.prices = prices;
        this.maxTipAmount = maxTipAmount;
        this.suggestedTipAmounts = suggestedTipAmounts;
        this.recurringTermsUrl = recurringTermsUrl;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Invoice.super.identifier();
    }

    private int flagsInitialize() {
        return Invoice.super.flags();
    }

    private boolean testInitialize() {
        return Invoice.super.test();
    }

    private boolean nameRequestedInitialize() {
        return Invoice.super.nameRequested();
    }

    private boolean phoneRequestedInitialize() {
        return Invoice.super.phoneRequested();
    }

    private boolean emailRequestedInitialize() {
        return Invoice.super.emailRequested();
    }

    private boolean shippingAddressRequestedInitialize() {
        return Invoice.super.shippingAddressRequested();
    }

    private boolean flexibleInitialize() {
        return Invoice.super.flexible();
    }

    private boolean phoneToProviderInitialize() {
        return Invoice.super.phoneToProvider();
    }

    private boolean emailToProviderInitialize() {
        return Invoice.super.emailToProvider();
    }

    private boolean recurringInitialize() {
        return Invoice.super.recurring();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean test() {
        InitShim shim = this.initShim;
        return shim != null ? shim.test() : this.test;
    }

    @Override
    public boolean nameRequested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nameRequested() : this.nameRequested;
    }

    @Override
    public boolean phoneRequested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.phoneRequested() : this.phoneRequested;
    }

    @Override
    public boolean emailRequested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.emailRequested() : this.emailRequested;
    }

    @Override
    public boolean shippingAddressRequested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shippingAddressRequested() : this.shippingAddressRequested;
    }

    @Override
    public boolean flexible() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flexible() : this.flexible;
    }

    @Override
    public boolean phoneToProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.phoneToProvider() : this.phoneToProvider;
    }

    @Override
    public boolean emailToProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.emailToProvider() : this.emailToProvider;
    }

    @Override
    public boolean recurring() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recurring() : this.recurring;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public List<LabeledPrice> prices() {
        return this.prices;
    }

    @Override
    @Nullable
    public Long maxTipAmount() {
        return this.maxTipAmount;
    }

    @Override
    @Nullable
    public List<Long> suggestedTipAmounts() {
        return this.suggestedTipAmounts;
    }

    @Override
    @Nullable
    public String recurringTermsUrl() {
        return this.recurringTermsUrl;
    }

    public final ImmutableInvoice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInvoice(value, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, value, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withTest(boolean value) {
        if (this.test == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, value, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withNameRequested(boolean value) {
        if (this.nameRequested == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, value, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withPhoneRequested(boolean value) {
        if (this.phoneRequested == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, value, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withEmailRequested(boolean value) {
        if (this.emailRequested == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, value, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withShippingAddressRequested(boolean value) {
        if (this.shippingAddressRequested == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, value, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withFlexible(boolean value) {
        if (this.flexible == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, value, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withPhoneToProvider(boolean value) {
        if (this.phoneToProvider == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, value, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withEmailToProvider(boolean value) {
        if (this.emailToProvider == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, value, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withRecurring(boolean value) {
        if (this.recurring == value) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, value, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, newValue, this.prices, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withPrices(LabeledPrice ... elements) {
        List<LabeledPrice> newValue = ImmutableInvoice.createUnmodifiableList(false, ImmutableInvoice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, newValue, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withPrices(Iterable<? extends LabeledPrice> elements) {
        if (this.prices == elements) {
            return this;
        }
        List<LabeledPrice> newValue = ImmutableInvoice.createUnmodifiableList(false, ImmutableInvoice.createSafeList(elements, true, false));
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, newValue, this.maxTipAmount, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withMaxTipAmount(@Nullable Long value) {
        if (Objects.equals(this.maxTipAmount, value)) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, value, this.suggestedTipAmounts, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withSuggestedTipAmounts(long ... elements) {
        if (elements == null) {
            return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, null, this.recurringTermsUrl);
        }
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableInvoice.createUnmodifiableList(false, wrappedList);
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, newValue, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withSuggestedTipAmounts(@Nullable Iterable<Long> elements) {
        if (this.suggestedTipAmounts == elements) {
            return this;
        }
        List<Long> newValue = elements == null ? null : ImmutableInvoice.createUnmodifiableList(false, ImmutableInvoice.createSafeList(elements, true, false));
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, newValue, this.recurringTermsUrl);
    }

    public final ImmutableInvoice withRecurringTermsUrl(@Nullable String value) {
        if (Objects.equals(this.recurringTermsUrl, value)) {
            return this;
        }
        return new ImmutableInvoice(this.identifier, this.flags, this.test, this.nameRequested, this.phoneRequested, this.emailRequested, this.shippingAddressRequested, this.flexible, this.phoneToProvider, this.emailToProvider, this.recurring, this.currency, this.prices, this.maxTipAmount, this.suggestedTipAmounts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvoice && this.equalTo(0, (ImmutableInvoice)another);
    }

    private boolean equalTo(int synthetic, ImmutableInvoice another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.test == another.test && this.nameRequested == another.nameRequested && this.phoneRequested == another.phoneRequested && this.emailRequested == another.emailRequested && this.shippingAddressRequested == another.shippingAddressRequested && this.flexible == another.flexible && this.phoneToProvider == another.phoneToProvider && this.emailToProvider == another.emailToProvider && this.recurring == another.recurring && this.currency.equals(another.currency) && this.prices.equals(another.prices) && Objects.equals(this.maxTipAmount, another.maxTipAmount) && Objects.equals(this.suggestedTipAmounts, another.suggestedTipAmounts) && Objects.equals(this.recurringTermsUrl, another.recurringTermsUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.test);
        h += (h << 5) + Boolean.hashCode(this.nameRequested);
        h += (h << 5) + Boolean.hashCode(this.phoneRequested);
        h += (h << 5) + Boolean.hashCode(this.emailRequested);
        h += (h << 5) + Boolean.hashCode(this.shippingAddressRequested);
        h += (h << 5) + Boolean.hashCode(this.flexible);
        h += (h << 5) + Boolean.hashCode(this.phoneToProvider);
        h += (h << 5) + Boolean.hashCode(this.emailToProvider);
        h += (h << 5) + Boolean.hashCode(this.recurring);
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.prices.hashCode();
        h += (h << 5) + Objects.hashCode(this.maxTipAmount);
        h += (h << 5) + Objects.hashCode(this.suggestedTipAmounts);
        h += (h << 5) + Objects.hashCode(this.recurringTermsUrl);
        return h;
    }

    public String toString() {
        return "Invoice{identifier=" + this.identifier + ", flags=" + this.flags + ", test=" + this.test + ", nameRequested=" + this.nameRequested + ", phoneRequested=" + this.phoneRequested + ", emailRequested=" + this.emailRequested + ", shippingAddressRequested=" + this.shippingAddressRequested + ", flexible=" + this.flexible + ", phoneToProvider=" + this.phoneToProvider + ", emailToProvider=" + this.emailToProvider + ", recurring=" + this.recurring + ", currency=" + this.currency + ", prices=" + this.prices + ", maxTipAmount=" + this.maxTipAmount + ", suggestedTipAmounts=" + this.suggestedTipAmounts + ", recurringTermsUrl=" + this.recurringTermsUrl + "}";
    }

    public static ImmutableInvoice of(String currency) {
        return new ImmutableInvoice(currency);
    }

    public static ImmutableInvoice copyOf(Invoice instance) {
        if (instance instanceof ImmutableInvoice) {
            return (ImmutableInvoice)instance;
        }
        return ImmutableInvoice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CURRENCY = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_TEST = 4L;
        private static final long OPT_BIT_NAME_REQUESTED = 8L;
        private static final long OPT_BIT_PHONE_REQUESTED = 16L;
        private static final long OPT_BIT_EMAIL_REQUESTED = 32L;
        private static final long OPT_BIT_SHIPPING_ADDRESS_REQUESTED = 64L;
        private static final long OPT_BIT_FLEXIBLE = 128L;
        private static final long OPT_BIT_PHONE_TO_PROVIDER = 256L;
        private static final long OPT_BIT_EMAIL_TO_PROVIDER = 512L;
        private static final long OPT_BIT_RECURRING = 1024L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean test;
        private boolean nameRequested;
        private boolean phoneRequested;
        private boolean emailRequested;
        private boolean shippingAddressRequested;
        private boolean flexible;
        private boolean phoneToProvider;
        private boolean emailToProvider;
        private boolean recurring;
        private String currency;
        private List<LabeledPrice> prices = new ArrayList<LabeledPrice>();
        private Long maxTipAmount;
        private List<Long> suggestedTipAmounts = null;
        private String recurringTermsUrl;

        private Builder() {
        }

        public final Builder from(Invoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Invoice instance;
            long bits = 0L;
            if (object instanceof Invoice) {
                String recurringTermsUrlValue;
                List<Long> suggestedTipAmountsValue;
                instance = (Invoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneToProvider(instance.phoneToProvider());
                this.emailRequested(instance.emailRequested());
                this.test(instance.test());
                this.recurring(instance.recurring());
                this.nameRequested(instance.nameRequested());
                this.shippingAddressRequested(instance.shippingAddressRequested());
                this.flags(instance.flags());
                this.emailToProvider(instance.emailToProvider());
                Long maxTipAmountValue = instance.maxTipAmount();
                if (maxTipAmountValue != null) {
                    this.maxTipAmount(maxTipAmountValue);
                }
                if ((suggestedTipAmountsValue = instance.suggestedTipAmounts()) != null) {
                    this.addAllSuggestedTipAmounts(suggestedTipAmountsValue);
                }
                if ((recurringTermsUrlValue = instance.recurringTermsUrl()) != null) {
                    this.recurringTermsUrl(recurringTermsUrlValue);
                }
                this.flexible(instance.flexible());
                this.phoneRequested(instance.phoneRequested());
                this.currency(instance.currency());
                this.addAllPrices(instance.prices());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder test(boolean test) {
            this.test = test;
            this.optBits |= 4L;
            return this;
        }

        public final Builder nameRequested(boolean nameRequested) {
            this.nameRequested = nameRequested;
            this.optBits |= 8L;
            return this;
        }

        public final Builder phoneRequested(boolean phoneRequested) {
            this.phoneRequested = phoneRequested;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder emailRequested(boolean emailRequested) {
            this.emailRequested = emailRequested;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder shippingAddressRequested(boolean shippingAddressRequested) {
            this.shippingAddressRequested = shippingAddressRequested;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder flexible(boolean flexible) {
            this.flexible = flexible;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder phoneToProvider(boolean phoneToProvider) {
            this.phoneToProvider = phoneToProvider;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder emailToProvider(boolean emailToProvider) {
            this.emailToProvider = emailToProvider;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder recurring(boolean recurring) {
            this.recurring = recurring;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPrice(LabeledPrice element) {
            this.prices.add(Objects.requireNonNull(element, "prices element"));
            return this;
        }

        public final Builder addPrices(LabeledPrice ... elements) {
            for (LabeledPrice element : elements) {
                this.prices.add(Objects.requireNonNull(element, "prices element"));
            }
            return this;
        }

        public final Builder prices(Iterable<? extends LabeledPrice> elements) {
            this.prices.clear();
            return this.addAllPrices(elements);
        }

        public final Builder addAllPrices(Iterable<? extends LabeledPrice> elements) {
            for (LabeledPrice labeledPrice : elements) {
                this.prices.add(Objects.requireNonNull(labeledPrice, "prices element"));
            }
            return this;
        }

        public final Builder maxTipAmount(@Nullable Long maxTipAmount) {
            this.maxTipAmount = maxTipAmount;
            return this;
        }

        public final Builder addSuggestedTipAmount(long element) {
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList<Long>();
            }
            this.suggestedTipAmounts.add(element);
            return this;
        }

        public final Builder addSuggestedTipAmounts(long ... elements) {
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.suggestedTipAmounts.add(element);
            }
            return this;
        }

        public final Builder suggestedTipAmounts(@Nullable Iterable<Long> elements) {
            if (elements == null) {
                this.suggestedTipAmounts = null;
                return this;
            }
            this.suggestedTipAmounts = new ArrayList<Long>();
            return this.addAllSuggestedTipAmounts(elements);
        }

        public final Builder addAllSuggestedTipAmounts(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "suggestedTipAmounts element");
            if (this.suggestedTipAmounts == null) {
                this.suggestedTipAmounts = new ArrayList<Long>();
            }
            for (Long element : elements) {
                this.suggestedTipAmounts.add(Objects.requireNonNull(element, "suggestedTipAmounts element"));
            }
            return this;
        }

        public final Builder recurringTermsUrl(@Nullable String recurringTermsUrl) {
            this.recurringTermsUrl = recurringTermsUrl;
            return this;
        }

        public ImmutableInvoice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvoice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean testIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean nameRequestedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean phoneRequestedIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean emailRequestedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean shippingAddressRequestedIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean flexibleIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean phoneToProviderIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean emailToProviderIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean recurringIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currency");
            }
            return "Cannot build Invoice, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte testBuildStage = 0;
        private boolean test;
        private byte nameRequestedBuildStage = 0;
        private boolean nameRequested;
        private byte phoneRequestedBuildStage = 0;
        private boolean phoneRequested;
        private byte emailRequestedBuildStage = 0;
        private boolean emailRequested;
        private byte shippingAddressRequestedBuildStage = 0;
        private boolean shippingAddressRequested;
        private byte flexibleBuildStage = 0;
        private boolean flexible;
        private byte phoneToProviderBuildStage = 0;
        private boolean phoneToProvider;
        private byte emailToProviderBuildStage = 0;
        private boolean emailToProvider;
        private byte recurringBuildStage = 0;
        private boolean recurring;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInvoice.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInvoice.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean test() {
            if (this.testBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.testBuildStage == 0) {
                this.testBuildStage = (byte)-1;
                this.test = ImmutableInvoice.this.testInitialize();
                this.testBuildStage = 1;
            }
            return this.test;
        }

        void test(boolean test) {
            this.test = test;
            this.testBuildStage = 1;
        }

        boolean nameRequested() {
            if (this.nameRequestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameRequestedBuildStage == 0) {
                this.nameRequestedBuildStage = (byte)-1;
                this.nameRequested = ImmutableInvoice.this.nameRequestedInitialize();
                this.nameRequestedBuildStage = 1;
            }
            return this.nameRequested;
        }

        void nameRequested(boolean nameRequested) {
            this.nameRequested = nameRequested;
            this.nameRequestedBuildStage = 1;
        }

        boolean phoneRequested() {
            if (this.phoneRequestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.phoneRequestedBuildStage == 0) {
                this.phoneRequestedBuildStage = (byte)-1;
                this.phoneRequested = ImmutableInvoice.this.phoneRequestedInitialize();
                this.phoneRequestedBuildStage = 1;
            }
            return this.phoneRequested;
        }

        void phoneRequested(boolean phoneRequested) {
            this.phoneRequested = phoneRequested;
            this.phoneRequestedBuildStage = 1;
        }

        boolean emailRequested() {
            if (this.emailRequestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.emailRequestedBuildStage == 0) {
                this.emailRequestedBuildStage = (byte)-1;
                this.emailRequested = ImmutableInvoice.this.emailRequestedInitialize();
                this.emailRequestedBuildStage = 1;
            }
            return this.emailRequested;
        }

        void emailRequested(boolean emailRequested) {
            this.emailRequested = emailRequested;
            this.emailRequestedBuildStage = 1;
        }

        boolean shippingAddressRequested() {
            if (this.shippingAddressRequestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.shippingAddressRequestedBuildStage == 0) {
                this.shippingAddressRequestedBuildStage = (byte)-1;
                this.shippingAddressRequested = ImmutableInvoice.this.shippingAddressRequestedInitialize();
                this.shippingAddressRequestedBuildStage = 1;
            }
            return this.shippingAddressRequested;
        }

        void shippingAddressRequested(boolean shippingAddressRequested) {
            this.shippingAddressRequested = shippingAddressRequested;
            this.shippingAddressRequestedBuildStage = 1;
        }

        boolean flexible() {
            if (this.flexibleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flexibleBuildStage == 0) {
                this.flexibleBuildStage = (byte)-1;
                this.flexible = ImmutableInvoice.this.flexibleInitialize();
                this.flexibleBuildStage = 1;
            }
            return this.flexible;
        }

        void flexible(boolean flexible) {
            this.flexible = flexible;
            this.flexibleBuildStage = 1;
        }

        boolean phoneToProvider() {
            if (this.phoneToProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.phoneToProviderBuildStage == 0) {
                this.phoneToProviderBuildStage = (byte)-1;
                this.phoneToProvider = ImmutableInvoice.this.phoneToProviderInitialize();
                this.phoneToProviderBuildStage = 1;
            }
            return this.phoneToProvider;
        }

        void phoneToProvider(boolean phoneToProvider) {
            this.phoneToProvider = phoneToProvider;
            this.phoneToProviderBuildStage = 1;
        }

        boolean emailToProvider() {
            if (this.emailToProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.emailToProviderBuildStage == 0) {
                this.emailToProviderBuildStage = (byte)-1;
                this.emailToProvider = ImmutableInvoice.this.emailToProviderInitialize();
                this.emailToProviderBuildStage = 1;
            }
            return this.emailToProvider;
        }

        void emailToProvider(boolean emailToProvider) {
            this.emailToProvider = emailToProvider;
            this.emailToProviderBuildStage = 1;
        }

        boolean recurring() {
            if (this.recurringBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recurringBuildStage == 0) {
                this.recurringBuildStage = (byte)-1;
                this.recurring = ImmutableInvoice.this.recurringInitialize();
                this.recurringBuildStage = 1;
            }
            return this.recurring;
        }

        void recurring(boolean recurring) {
            this.recurring = recurring;
            this.recurringBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.testBuildStage == -1) {
                attributes.add("test");
            }
            if (this.nameRequestedBuildStage == -1) {
                attributes.add("nameRequested");
            }
            if (this.phoneRequestedBuildStage == -1) {
                attributes.add("phoneRequested");
            }
            if (this.emailRequestedBuildStage == -1) {
                attributes.add("emailRequested");
            }
            if (this.shippingAddressRequestedBuildStage == -1) {
                attributes.add("shippingAddressRequested");
            }
            if (this.flexibleBuildStage == -1) {
                attributes.add("flexible");
            }
            if (this.phoneToProviderBuildStage == -1) {
                attributes.add("phoneToProvider");
            }
            if (this.emailToProviderBuildStage == -1) {
                attributes.add("emailToProvider");
            }
            if (this.recurringBuildStage == -1) {
                attributes.add("recurring");
            }
            return "Cannot build Invoice, attribute initializers form cycle " + attributes;
        }
    }
}

