/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.IpPort;
import telegram4j.tl.IpPortSecret;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableIpPortSecret
implements IpPortSecret {
    private final int identifier;
    private final int ipv4;
    private final int port;
    private final ByteBuf secret;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableIpPortSecret(int ipv4, int port) {
        this.ipv4 = ipv4;
        this.port = port;
        this.secret = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableIpPortSecret(Builder builder) {
        this.ipv4 = builder.ipv4;
        this.port = builder.port;
        this.secret = builder.secret_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableIpPortSecret(int identifier, int ipv4, int port, ByteBuf secret) {
        this.identifier = identifier;
        this.ipv4 = ipv4;
        this.port = port;
        this.secret = secret;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return IpPortSecret.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int ipv4() {
        return this.ipv4;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public ByteBuf secret() {
        return this.secret.duplicate();
    }

    public final ImmutableIpPortSecret withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableIpPortSecret(value, this.ipv4, this.port, this.secret);
    }

    public final ImmutableIpPortSecret withIpv4(int value) {
        if (this.ipv4 == value) {
            return this;
        }
        return new ImmutableIpPortSecret(this.identifier, value, this.port, this.secret);
    }

    public final ImmutableIpPortSecret withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableIpPortSecret(this.identifier, this.ipv4, value, this.secret);
    }

    public ImmutableIpPortSecret withSecret(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secret == newValue) {
            return this;
        }
        return new ImmutableIpPortSecret(this.identifier, this.ipv4, this.port, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIpPortSecret && this.equalTo(0, (ImmutableIpPortSecret)another);
    }

    private boolean equalTo(int synthetic, ImmutableIpPortSecret another) {
        return this.identifier == another.identifier && this.ipv4 == another.ipv4 && this.port == another.port && this.secret().equals((Object)another.secret());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.ipv4;
        h += (h << 5) + this.port;
        h += (h << 5) + this.secret().hashCode();
        return h;
    }

    public String toString() {
        return "IpPortSecret{identifier=" + this.identifier + ", ipv4=" + this.ipv4 + ", port=" + this.port + ", secret=" + ByteBufUtil.hexDump((ByteBuf)this.secret) + "}";
    }

    public static ImmutableIpPortSecret of(int ipv4, int port) {
        return new ImmutableIpPortSecret(ipv4, port);
    }

    public static ImmutableIpPortSecret copyOf(IpPortSecret instance) {
        if (instance instanceof ImmutableIpPortSecret) {
            return (ImmutableIpPortSecret)instance;
        }
        return ImmutableIpPortSecret.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_IPV4 = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf secret_value = null;
        private int identifier;
        private int ipv4;
        private int port;

        private Builder() {
        }

        public final Builder from(IpPort instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IpPortSecret instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IpPort instance;
            long bits = 0L;
            if (object instanceof IpPort) {
                instance = (IpPort)object;
                if ((bits & 2L) == 0L) {
                    this.ipv4(instance.ipv4());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.port(instance.port());
                    bits |= 4L;
                }
            }
            if (object instanceof IpPortSecret) {
                instance = (IpPortSecret)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.secret(instance.secret());
                if ((bits & 2L) == 0L) {
                    this.ipv4(instance.ipv4());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.port(instance.port());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder ipv4(int ipv4) {
            this.ipv4 = ipv4;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder secret(ByteBuf value) {
            this.secret_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableIpPortSecret build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIpPortSecret(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ipv4");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build IpPortSecret, some of required attributes are not set " + attributes;
        }

        private ByteBuf secret_build() {
            return Objects.requireNonNull(this.secret_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableIpPortSecret.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build IpPortSecret, attribute initializers form cycle " + attributes;
        }
    }
}

