/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.KeyboardButtonCallback;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableKeyboardButtonCallback
implements KeyboardButtonCallback {
    private final int identifier;
    private final int flags;
    private final boolean requiresPassword;
    private final String text;
    private final ByteBuf data;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKeyboardButtonCallback(String text) {
        this.text = Objects.requireNonNull(text, "text");
        this.data = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requiresPassword = this.initShim.requiresPassword();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonCallback(Builder builder) {
        this.text = builder.text;
        this.data = builder.data_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.requiresPasswordIsSet()) {
            this.initShim.requiresPassword(builder.requiresPassword);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requiresPassword = this.initShim.requiresPassword();
        this.initShim = null;
    }

    private ImmutableKeyboardButtonCallback(int identifier, int flags, boolean requiresPassword, String text, ByteBuf data) {
        this.identifier = identifier;
        this.flags = flags;
        this.requiresPassword = requiresPassword;
        this.text = text;
        this.data = data;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return KeyboardButtonCallback.super.identifier();
    }

    private int flagsInitialize() {
        return KeyboardButtonCallback.super.flags();
    }

    private boolean requiresPasswordInitialize() {
        return KeyboardButtonCallback.super.requiresPassword();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean requiresPassword() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requiresPassword() : this.requiresPassword;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public ByteBuf data() {
        return this.data.duplicate();
    }

    public final ImmutableKeyboardButtonCallback withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableKeyboardButtonCallback(value, this.flags, this.requiresPassword, this.text, this.data);
    }

    public final ImmutableKeyboardButtonCallback withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableKeyboardButtonCallback(this.identifier, value, this.requiresPassword, this.text, this.data);
    }

    public final ImmutableKeyboardButtonCallback withRequiresPassword(boolean value) {
        if (this.requiresPassword == value) {
            return this;
        }
        return new ImmutableKeyboardButtonCallback(this.identifier, this.flags, value, this.text, this.data);
    }

    public final ImmutableKeyboardButtonCallback withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyboardButtonCallback(this.identifier, this.flags, this.requiresPassword, newValue, this.data);
    }

    public ImmutableKeyboardButtonCallback withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableKeyboardButtonCallback(this.identifier, this.flags, this.requiresPassword, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyboardButtonCallback && this.equalTo(0, (ImmutableKeyboardButtonCallback)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyboardButtonCallback another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.requiresPassword == another.requiresPassword && this.text.equals(another.text) && this.data().equals((Object)another.data());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.requiresPassword);
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.data().hashCode();
        return h;
    }

    public String toString() {
        return "KeyboardButtonCallback{identifier=" + this.identifier + ", flags=" + this.flags + ", requiresPassword=" + this.requiresPassword + ", text=" + this.text + ", data=" + ByteBufUtil.hexDump((ByteBuf)this.data) + "}";
    }

    public static ImmutableKeyboardButtonCallback of(String text) {
        return new ImmutableKeyboardButtonCallback(text);
    }

    public static ImmutableKeyboardButtonCallback copyOf(KeyboardButtonCallback instance) {
        if (instance instanceof ImmutableKeyboardButtonCallback) {
            return (ImmutableKeyboardButtonCallback)instance;
        }
        return ImmutableKeyboardButtonCallback.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REQUIRES_PASSWORD = 4L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf data_value = null;
        private int identifier;
        private int flags;
        private boolean requiresPassword;
        private String text;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButtonCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButtonCallback) {
                instance = (KeyboardButtonCallback)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
                this.requiresPassword(instance.requiresPassword());
                this.data(instance.data());
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder requiresPassword(boolean requiresPassword) {
            this.requiresPassword = requiresPassword;
            this.optBits |= 4L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder data(ByteBuf value) {
            this.data_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableKeyboardButtonCallback build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyboardButtonCallback(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean requiresPasswordIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build KeyboardButtonCallback, some of required attributes are not set " + attributes;
        }

        private ByteBuf data_build() {
            return Objects.requireNonNull(this.data_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte requiresPasswordBuildStage = 0;
        private boolean requiresPassword;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableKeyboardButtonCallback.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableKeyboardButtonCallback.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean requiresPassword() {
            if (this.requiresPasswordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requiresPasswordBuildStage == 0) {
                this.requiresPasswordBuildStage = (byte)-1;
                this.requiresPassword = ImmutableKeyboardButtonCallback.this.requiresPasswordInitialize();
                this.requiresPasswordBuildStage = 1;
            }
            return this.requiresPassword;
        }

        void requiresPassword(boolean requiresPassword) {
            this.requiresPassword = requiresPassword;
            this.requiresPasswordBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.requiresPasswordBuildStage == -1) {
                attributes.add("requiresPassword");
            }
            return "Cannot build KeyboardButtonCallback, attribute initializers form cycle " + attributes;
        }
    }
}

